@extends('layouts.app')

@section('title', 'Videos & Webinars')

@section('content')
<div class="max-w-6xl mx-auto px-4 py-10 space-y-6">

    {{-- Page header --}}
    <section class="rounded-3xl border border-slate-200 bg-white shadow-sm px-5 py-4 flex flex-col md:flex-row md:items-center md:justify-between gap-3">
        <div>
            <h1 class="text-xl md:text-2xl font-semibold tracking-tight text-slate-900 flex items-center gap-2">
                <span class="inline-flex h-6 w-6 items-center justify-center rounded-full bg-red-500 text-white text-[11px] font-bold">
                    ▶
                </span>
                <span>Videos &amp; Webinars</span>
            </h1>
            <p class="text-xs text-slate-500 mt-1">
                Browse all Myositis India videos by language. Click any thumbnail to play without leaving the page.
            </p>
        </div>
        <div class="flex flex-wrap gap-2">
            <a href="https://www.youtube.com/@myositis_india"
               target="_blank" rel="noopener"
               class="inline-flex items-center gap-2 px-3 py-2 rounded-full border border-slate-200 text-[11px] text-slate-700 hover:bg-slate-50">
                <span class="w-3 h-3 bg-red-500 rounded-[4px]"></span>
                <span>Open channel on YouTube</span>
            </a>
        </div>
    </section>

    {{-- Language tabs --}}
    <section class="rounded-2xl border border-slate-200 bg-slate-50/70 px-3 py-2">
        <div class="flex flex-wrap gap-2 text-[11px]">
            @if(count($languages))
                @foreach($languages as $lang)
                    <a href="{{ route('videos.index', ['language' => $lang]) }}"
                       class="inline-flex items-center gap-1 px-3 py-1.5 rounded-full border
                              {{ $activeLanguage === $lang
                                ? 'bg-white border-red-500 text-red-600 font-semibold shadow-sm'
                                : 'bg-white/70 border-slate-200 text-slate-600 hover:bg-white' }}">
                        <span class="h-1.5 w-1.5 rounded-full {{ $activeLanguage === $lang ? 'bg-red-500' : 'bg-slate-400' }}"></span>
                        <span>{{ $lang }}</span>
                    </a>
                @endforeach
            @else
                <span class="text-slate-500">No languages yet. Add videos from Admin panel.</span>
            @endif
        </div>
    </section>

    @if($firstVideo)
        {{-- Main player --}}
        <section class="grid gap-4 md:grid-cols-[minmax(0,2fr)_minmax(0,1.2fr)]">
            <div class="rounded-2xl border border-slate-200 bg-black overflow-hidden">
                <div class="aspect-video bg-black">
                    <iframe id="videosMainPlayer"
                            src="https://www.youtube.com/embed/{{ $firstVideo->youtube_id }}"
                            title="{{ $firstVideo->title }}"
                            loading="lazy"
                            class="w-full h-full"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                            allowfullscreen></iframe>
                </div>
                <div class="px-4 py-3 bg-slate-950/80 text-xs text-slate-50">
                    <div class="font-semibold text-[13px]">
                        {{ $firstVideo->title }}
                    </div>
                    <div class="mt-1 text-slate-300 flex flex-wrap items-center gap-2">
                        @if($activeLanguage)
                            <span class="inline-flex items-center gap-1 px-2 py-0.5 rounded-full bg-slate-800 text-[10px]">
                                <span class="h-1.5 w-1.5 rounded-full bg-emerald-400"></span>
                                {{ $activeLanguage }}
                            </span>
                        @endif
                        @if($firstVideo->meta)
                            <span class="text-[11px]">{{ $firstVideo->meta }}</span>
                        @endif
                    </div>
                </div>
            </div>

            {{-- Side list (current language) --}}
            <div class="rounded-2xl border border-slate-200 bg-white p-3 text-xs">
                <div class="flex items-center justify-between mb-2">
                    <span class="text-[11px] text-slate-500 uppercase tracking-[0.16em]">Playlist</span>
                    @if($activeLanguage)
                        <span class="px-2 py-0.5 rounded-full bg-slate-100 text-[10px] text-slate-600">
                            {{ $activeLanguage }}
                        </span>
                    @endif
                </div>
                <div class="space-y-2 max-h-[360px] overflow-y-auto pr-1" id="videosPlaylist">
                    @foreach($videos as $video)
                        <article class="flex gap-2 items-center cursor-pointer rounded-xl border border-transparent hover:border-slate-200 hover:bg-slate-50 p-1.5"
                                 data-vid="{{ $video->youtube_id }}">
                            <div class="w-32 shrink-0 rounded-lg overflow-hidden bg-slate-900">
                                <img src="https://i.ytimg.com/vi/{{ $video->youtube_id }}/hqdefault.jpg"
                                     alt="{{ $video->title }}"
                                     class="w-full h-full object-cover">
                            </div>
                            <div class="flex-1">
                                <div class="font-semibold text-[12px] text-slate-900 line-clamp-2">
                                    {{ $video->title }}
                                </div>
                                <div class="text-[11px] text-slate-500 mt-1">
                                    {{ $video->meta ?? 'YouTube video' }}
                                </div>
                            </div>
                        </article>
                    @endforeach
                </div>
            </div>
        </section>

        {{-- Grid of all videos (thumbnails only) --}}
        <section class="rounded-2xl border border-slate-200 bg-white shadow-sm p-4">
            <div class="flex items-center justify-between mb-3">
                <h2 class="text-sm font-semibold text-slate-900">
                    All videos in {{ $activeLanguage ?? 'all languages' }}
                </h2>
                <span class="text-[11px] text-slate-500">
                    {{ $videos->count() }} video(s)
                </span>
            </div>

            <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
                @foreach($videos as $video)
                    <article class="group cursor-pointer"
                             data-vid="{{ $video->youtube_id }}">
                        <div class="rounded-xl overflow-hidden border border-slate-200 bg-slate-900">
                            <img src="https://i.ytimg.com/vi/{{ $video->youtube_id }}/hqdefault.jpg"
                                 alt="{{ $video->title }}"
                                 class="w-full h-full object-cover group-hover:opacity-90 transition">
                        </div>
                        <div class="mt-2 text-xs">
                            <div class="font-semibold text-[12px] text-slate-900 line-clamp-2">
                                {{ $video->title }}
                            </div>
                            <div class="text-[11px] text-slate-500 mt-1">
                                {{ $video->meta ?? 'YouTube video' }}
                            </div>
                        </div>
                    </article>
                @endforeach
            </div>
        </section>
    @else
        <section class="rounded-2xl border border-slate-200 bg-white px-5 py-6 text-xs text-slate-500">
            No videos published yet. Please add and publish videos from the Admin panel.
        </section>
    @endif
</div>

<script>
  // All click targets (side list + grid) control the ONE main iframe
  (function(){
    const player = document.getElementById('videosMainPlayer');
    const playlist = document.getElementById('videosPlaylist');
    if (!player) return;

    function attachClicks(root){
      if (!root) return;
      root.querySelectorAll('[data-vid]').forEach(el => {
        el.addEventListener('click', () => {
          const id = el.getAttribute('data-vid');
          if (!id) return;
          player.src = 'https://www.youtube.com/embed/' + id;
          window.scrollTo({ top: player.offsetTop - 80, behavior: 'smooth' });
        });
      });
    }

    attachClicks(document);
  })();
</script>
@endsection
