@extends('volunteer.layouts.app')

@section('content')

<div class="max-w-[1600px] mx-auto px-4 py-6">
    
    <!-- COMPACT HEADER -->
    <div class="mb-6 flex flex-col md:flex-row md:items-center justify-between gap-4">
        <div>
            <nav class="flex items-center gap-2 mb-1">
                <a href="{{ route('volunteer.dashboard') }}" class="text-[10px] font-bold text-slate-400 uppercase hover:text-orange-600 transition">Dashboard</a>
                <svg class="w-3 h-3 text-slate-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path></svg>
                <span class="text-[10px] font-bold text-slate-600 uppercase">My Service Schedule</span>
            </nav>
            <h2 class="text-xl font-bold text-slate-800 tracking-tight">Assigned Events</h2>
        </div>

        <div class="flex items-center gap-3">
            <div class="relative">
                <input type="text" placeholder="Filter clinical events..." class="pl-9 pr-4 py-2 bg-white border border-[#d9e2f2] rounded-lg text-xs focus:ring-2 focus:ring-orange-500/10 outline-none w-full sm:w-64 transition">
                <svg class="w-4 h-4 text-slate-400 absolute left-3 top-1/2 -translate-y-1/2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
            </div>
            <button class="flex items-center gap-2 px-3 py-2 bg-white border border-[#d9e2f2] rounded-lg text-[11px] font-bold text-slate-600 hover:bg-slate-50 transition uppercase tracking-wider">
                <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586a1 1 0 01-.293.707l-6.414 6.414a1 1 0 00-.293.707V17l-4 4v-6.586a1 1 0 00-.293-.707L3.293 7.293A1 1 0 013 6.586V4z"></path></svg>
                Filters
            </button>
        </div>
    </div>

    <!-- HIGH DENSITY TABLE -->
    <div class="bg-white rounded-xl border border-[#d9e2f2] shadow-sm overflow-hidden min-h-[500px]">
        <div class="overflow-x-auto">
            <table class="w-full text-left">
                <thead>
                    <tr class="bg-slate-50 text-[10px] font-black text-slate-400 uppercase tracking-widest border-b border-slate-100">
                        <th class="px-6 py-4">Title & Classification</th>
                        <th class="px-6 py-4">Timeline</th>
                        <th class="px-6 py-4">Location</th>
                        <th class="px-6 py-4">Status</th>
                        <th class="px-6 py-4 text-right">Options</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-50">
                    @forelse($events as $event)
                    <tr class="hover:bg-slate-50/50 transition">
                        <td class="px-6 py-3">
                            <div>
                                <p class="text-sm font-bold text-slate-700 leading-tight mb-0.5">{{ $event->title }}</p>
                                <p class="text-[10px] text-slate-400 font-medium uppercase tracking-tight">Community Awareness</p>
                            </div>
                        </td>
                        <td class="px-6 py-3">
                            <span class="text-xs text-slate-600 font-bold whitespace-nowrap">{{ $event->start_datetime->format('M d, Y') }}</span>
                            <p class="text-[10px] text-slate-400 font-medium tracking-tighter">{{ $event->start_datetime->format('h:i A') }}</p>
                        </td>
                        <td class="px-6 py-3">
                            <div class="flex items-center gap-1.5 text-slate-600">
                                <svg class="w-3.5 h-3.5 text-slate-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                                <span class="text-[11px] font-medium max-w-[120px] truncate">{{ $event->location }}</span>
                            </div>
                        </td>
                        <td class="px-6 py-3">
                            @if($event->start_datetime > now())
                                <span class="px-2 py-0.5 bg-orange-50 text-orange-600 text-[9px] font-black uppercase rounded border border-orange-100 tracking-wider">Scheduled</span>
                            @else
                                <span class="px-2 py-0.5 bg-slate-50 text-slate-400 text-[9px] font-black uppercase rounded border border-slate-100 tracking-wider">Completed</span>
                            @endif
                        </td>
                        <td class="px-6 py-3 text-right">
                            <div class="flex items-center justify-end gap-2">
                                <button class="p-1.5 hover:bg-orange-50 text-slate-400 hover:text-orange-600 rounded transition" title="Inspect">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path></svg>
                                </button>
                                <button class="p-1.5 hover:bg-slate-100 text-slate-400 hover:text-slate-600 rounded transition" title="Guidelines">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path></svg>
                                </button>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="px-6 py-20 text-center">
                            <div class="flex flex-col items-center">
                                <div class="w-12 h-12 bg-slate-50 text-slate-200 rounded-full flex items-center justify-center mb-3">
                                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4"></path></svg>
                                </div>
                                <p class="text-sm font-bold text-slate-400">No events currently assigned for volunteer support.</p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($events->hasPages())
        <div class="px-6 py-4 bg-slate-50/50 border-t border-slate-100">
            {{ $events->links() }}
        </div>
        @else
        <div class="px-6 py-4 bg-slate-50/50 border-t border-slate-100 flex items-center justify-between">
            <span class="text-[10px] font-black text-slate-400 uppercase tracking-widest">Service Repository Control</span>
            <span class="text-[10px] font-bold text-slate-400">Displaying {{ $events->count() }} assignments</span>
        </div>
        @endif
    </div>
</div>

@endsection
