<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Volunteer Dashboard</title>
    @vite(['resources/css/app.css','resources/js/app.js'])
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <style>
        [x-cloak] { display: none !important; }
        .custom-scrollbar::-webkit-scrollbar { width: 5px; }
        .custom-scrollbar::-webkit-scrollbar-track { background: transparent; }
        .custom-scrollbar::-webkit-scrollbar-thumb { background: #f97316; border-radius: 10px; }
        .orange-glow { box-shadow: 0 10px 30px -5px rgba(249, 115, 22, 0.2); }
        .orange-glow-icon { box-shadow: 0 8px 20px -4px rgba(249, 115, 22, 0.4); }
        .soft-card-shadow { box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05), 0 2px 4px -1px rgba(0, 0, 0, 0.03); }
    </style>
</head>

<body class="bg-[#eef3f9] text-[#0f172a] antialiased" x-data="{ sidebarOpen: false }">

@include('volunteer.layouts.navbar')

<div class="flex">
    <!-- Sidebar -->
    @include('volunteer.layouts.sidebar')

    <!-- Main Content Area -->
    <div class="flex-1 flex flex-col min-h-screen lg:ml-72 transition-all duration-300">
        <main class="flex-1 px-4 sm:px-6 lg:px-10 py-8 pt-24 pb-20">
            @yield('content')
        </main>
        
        @include('volunteer.layouts.footer')
    </div>
</div>

<!-- Mobile Sidebar Overlay -->
<div x-show="sidebarOpen" 
     x-transition:enter="transition ease-out duration-300"
     x-transition:enter-start="opacity-0"
     x-transition:enter-end="opacity-100"
     x-transition:leave="transition ease-in duration-200"
     x-transition:leave-start="opacity-100"
     x-transition:leave-end="opacity-0"
     @click="sidebarOpen = false"
     class="fixed inset-0 bg-slate-900/50 backdrop-blur-sm z-[55] lg:hidden" 
     x-cloak>
</div>

</body>
</html>
