<nav class="fixed top-0 right-0 left-0 lg:left-72 h-14 bg-white border-b border-[#d9e2f2] z-50 transition-all duration-300">
    <div class="h-full flex items-center justify-between px-4 sm:px-6">
        
        <div class="flex items-center gap-3">
            <!-- Mobile Menu Toggle -->
            <button @click="sidebarOpen = true" class="lg:hidden p-1.5 text-slate-500 hover:bg-slate-50 rounded-lg transition">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path></svg>
            </button>

            <div class="flex items-center gap-2">
                <div class="w-8 h-8 rounded-lg bg-[#f97316] flex items-center justify-center shadow-sm">
                    <span class="text-white font-bold text-sm">V</span>
                </div>
                <h1 class="text-sm font-bold text-slate-800 tracking-tight">
                    Volunteer Portal <span class="text-slate-400 font-medium ml-1">Myositis India</span>
                </h1>
            </div>
        </div>

        <div class="flex items-center gap-4">
            <div class="hidden md:flex items-center gap-1.5 px-2 py-1 bg-orange-50 text-orange-700 rounded-md border border-orange-100">
                <div class="w-1.5 h-1.5 bg-orange-500 rounded-full animate-pulse"></div>
                <span class="text-[10px] font-bold uppercase tracking-wider">Active</span>
            </div>

            <div class="relative group">
                <button class="flex items-center gap-2 pl-1 pr-1 py-1 rounded-lg border border-[#d9e2f2] hover:bg-slate-50 transition-all">
                    <div class="w-8 h-8 rounded-lg bg-slate-100 border border-slate-200 flex items-center justify-center text-slate-500 overflow-hidden">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg>
                    </div>
                    <span class="text-xs font-bold text-slate-700 pr-2">{{ auth()->user()->name ?? 'Volunteer' }}</span>
                </button>

                <div class="absolute right-0 mt-2 w-48 bg-white border border-[#d9e2f2] rounded-xl shadow-lg opacity-0 invisible group-hover:visible group-hover:opacity-100 transition-all duration-200 p-1">
                    <a href="#" class="flex items-center gap-2 px-3 py-2 text-xs text-slate-700 hover:bg-slate-50 rounded-lg transition font-medium">
                        Profile Settings
                    </a>
                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <button class="w-full flex items-center gap-2 px-3 py-2 text-xs text-rose-600 hover:bg-rose-50 rounded-lg transition font-medium">
                            Logout
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</nav>
