<aside class="fixed left-0 top-0 w-72 h-screen bg-[#0f172a] text-slate-400 border-r border-slate-800 flex flex-col z-[60] transition-transform duration-300 transform lg:translate-x-0 overflow-hidden"
       :class="sidebarOpen ? 'translate-x-0' : '-translate-x-full'">
    
    <!-- Mobile Close Button -->
    <button @click="sidebarOpen = false" class="lg:hidden absolute top-4 right-4 text-slate-500 hover:text-white transition-colors duration-200">
        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
    </button>

    <div class="flex-1 flex flex-col pt-14 lg:pt-0 overflow-y-auto custom-scrollbar">
        <!-- Logo/Brand Section -->
        <div class="px-6 py-8 border-b border-slate-800/50">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-orange-500 rounded-xl flex items-center justify-center shadow-lg shadow-orange-500/20">
                    <span class="text-white font-black text-xl">V</span>
                </div>
                <div>
                    <h2 class="text-white font-bold text-base tracking-tight leading-none uppercase">Myositis</h2>
                    <p class="text-[10px] text-slate-500 font-bold uppercase tracking-widest mt-1">Volunteer Hub</p>
                </div>
            </div>
        </div>

        <nav class="flex-1 px-5 py-8 space-y-2">
            <p class="text-[10px] font-black text-slate-500 uppercase tracking-[0.25em] px-4 mb-6">Operations Control</p>
            
            <a href="{{ route('volunteer.dashboard') }}" 
               class="flex items-center gap-4 px-5 py-4 rounded-2xl text-xs font-black uppercase tracking-widest transition-all duration-300 group
               {{ request()->routeIs('volunteer.dashboard') 
                    ? 'bg-orange-600 text-white shadow-lg shadow-orange-600/20' 
                    : 'hover:bg-slate-800 hover:text-slate-200' }}\">
                <svg class="w-5 h-5 {{ request()->routeIs('volunteer.dashboard') ? 'text-white' : 'text-slate-500 group-hover:text-slate-300' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2zM4 14a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2zM14 14a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"></path>
                </svg>
                Overview
            </a>

            <a href="{{ route('volunteer.events.index') }}" 
               class="flex items-center gap-4 px-5 py-4 rounded-2xl text-xs font-black uppercase tracking-widest transition-all duration-300 group
               {{ request()->routeIs('volunteer.events.*') 
                    ? 'bg-orange-600 text-white shadow-lg shadow-orange-600/20' 
                    : 'hover:bg-slate-800 hover:text-slate-200' }}\">
                <svg class="w-5 h-5 {{ request()->routeIs('volunteer.events.*') ? 'text-white' : 'text-slate-500 group-hover:text-slate-300' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                </svg>
                My Events
            </a>

            <a href="{{ route('volunteer.todos.index') }}" 
               class="flex items-center gap-4 px-5 py-4 rounded-2xl text-xs font-black uppercase tracking-widest transition-all duration-300 group
               {{ request()->routeIs('volunteer.todos.*') 
                    ? 'bg-orange-600 text-white shadow-lg shadow-orange-600/20' 
                    : 'hover:bg-slate-800 hover:text-slate-200' }}\">
                <svg class="w-5 h-5 {{ request()->routeIs('volunteer.todos.*') ? 'text-white' : 'text-slate-500 group-hover:text-slate-300' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6M9 16h6M9 8h6M5 4h14v16H5z"></path>
                </svg>
                My Tasks
            </a>
        </nav>

        <!-- Sidebar Footer -->
        <div class="p-4 mt-auto border-t border-slate-800/50 bg-slate-900/30">
            <div class="flex items-center gap-3 p-3 rounded-2xl bg-slate-800/50 border border-slate-700/30">
                <div class="w-8 h-8 rounded-lg bg-orange-500/10 border border-orange-500/20 flex items-center justify-center">
                    <div class="w-2 h-2 rounded-full bg-orange-500 animate-pulse"></div>
                </div>
                <div>
                    <p class="text-[10px] font-black text-slate-300 uppercase leading-none">V4.0.2 Premium</p>
                    <p class="text-[9px] text-slate-500 font-bold uppercase tracking-tighter mt-1">Volunteer Edition</p>
                </div>
            </div>
        </div>
    </div>
</aside>
