@extends('volunteer.layouts.app')

@section('content')
<div class="p-6">
    <h1 class="text-2xl font-bold mb-4">My Tasks</h1>

    <div class="bg-white rounded shadow divide-y">
        @forelse($todos as $todo)
        <div class="block p-4 hover:bg-slate-50 flex items-start gap-4">
            <div class="w-2 rounded h-full {{ $todo->priority == 'low' ? 'bg-green-500' : ($todo->priority=='medium' ? 'bg-amber-400' : ($todo->priority=='high' ? 'bg-red-500' : 'bg-purple-600')) }}"></div>
            <div class="flex-1">
                <a href="{{ route('volunteer.todos.show', $todo) }}" class="block">
                    <h3 class="font-bold">{{ $todo->title }}</h3>
                    <p class="text-sm text-slate-600 mt-1">{{ Str::limit($todo->description, 140) }}</p>
                    <div class="mt-2 text-xs text-slate-500">Due: {{ optional($todo->due_date)->format('Y-m-d') ?? '—' }} · Status: {{ ucfirst(str_replace('_',' ', $todo->status)) }}</div>
                </a>
            </div>

            <div class="flex items-center gap-2">
                @can('update', $todo)
                    @if($todo->status !== App\Models\Todo::STATUS_COMPLETED)
                        <form action="{{ route('volunteer.todos.complete', $todo) }}" method="POST" onsubmit="return confirm('Mark this task as completed?');">
                            @csrf
                            <button class="px-3 py-2 bg-emerald-600 text-white rounded text-sm">Mark Done</button>
                        </form>
                    @else
                        <span class="px-3 py-1 text-xs text-slate-500">Completed</span>
                    @endif
                @else
                    <span class="text-xs text-slate-400">Assigned to others</span>
                @endcan
            </div>
        </div>
        @empty
        <div class="p-4 text-sm text-slate-500">No tasks assigned.</div>
        @endforelse
    </div>

    <div class="mt-4">{{ $todos->links() }}</div>
</div>
@endsection