@extends('volunteer.layouts.app')

@section('content')
<div class="p-6">
    <div class="flex items-center justify-between mb-4">
        <h1 class="text-2xl font-bold">{{ $todo->title }}</h1>
        <div class="text-sm">Priority: <span class="font-bold">{{ ucfirst($todo->priority) }}</span></div>
    </div>

    <div class="bg-white rounded shadow p-4">
        <div class="mb-4">{!! nl2br(e($todo->description)) !!}</div>

        <div class="mb-4">
            @can('update', $todo)
                <form action="{{ route('volunteer.todos.status', $todo) }}" method="POST" class="flex items-center gap-3">
                    @csrf
                    @method('PATCH')
                    <select name="status" class="border p-2 rounded">
                        <option value="pending" {{ $todo->status=='pending' ? 'selected' : '' }}>Pending</option>
                        <option value="in_progress" {{ $todo->status=='in_progress' ? 'selected' : '' }}>In Progress</option>
                        <option value="blocked" {{ $todo->status=='blocked' ? 'selected' : '' }}>Blocked</option>
                        <option value="completed" {{ $todo->status=='completed' ? 'selected' : '' }}>Completed</option>
                        <option value="cancelled" {{ $todo->status=='cancelled' ? 'selected' : '' }}>Cancelled</option>
                    </select>
                    <input type="number" name="progress" min="0" max="100" value="{{ $todo->progress }}" class="border p-2 rounded w-24" />
                    <button class="bg-blue-600 text-white px-3 py-2 rounded">Save</button>
                </form>

                @if($todo->status !== App\Models\Todo::STATUS_COMPLETED)
                    <form action="{{ route('volunteer.todos.complete', $todo) }}" method="POST" class="inline-block ml-3" onsubmit="return confirm('Mark this task as completed?');">
                        @csrf
                        <button class="px-3 py-2 bg-emerald-600 text-white rounded">Mark as Done</button>
                    </form>
                @endif
            @else
                <div class="text-sm text-slate-500 italic">You can only update tasks that are assigned to you. If this task was assigned to you, please contact support.</div>
            @endcan
        </div>

        <div>
            <h4 class="font-bold">Updates</h4>
            <form action="{{ route('volunteer.todos.updates', $todo) }}" method="POST" class="mt-3">
                @csrf
                <textarea name="content" class="w-full border rounded p-2" rows="4" placeholder="Add a quick update"></textarea>
                <div class="mt-2 flex gap-2">
                    <button class="bg-blue-600 text-white px-3 py-2 rounded">Post update</button>
                </div>
            </form>

            <div class="mt-4">
                @foreach($todo->updates as $u)
                    <div class="py-2 border-b">
                        <div class="text-xs text-slate-500">{{ $u->user->name }} &middot; {{ $u->created_at->diffForHumans() }}</div>
                        <div class="mt-1">{{ $u->content }}</div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
@endsection