<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegistrationController;
use App\Http\Controllers\Admin\AdminDashboardController;
use App\Http\Controllers\Support\SupportDashboardController;
use App\Http\Controllers\Seo\SeoDashboardController;
use App\Http\Controllers\Doctor\DoctorDashboardController;
use App\Http\Controllers\Patient\PatientDashboardController;
use App\Http\Controllers\Volunteer\VolunteerDashboardController;
use App\Http\Controllers\Admin\AdminRegistrationApprovalController;
use App\Http\Controllers\Admin\YouTubeVideoController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Admin\LatestUpdateController;
use App\Http\Controllers\Admin\AdminUserController;
use App\Http\Controllers\PatientStoryController;
use App\Http\Controllers\Admin\PatientStoryAdminController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\Admin\EventAdminController; 
use App\Http\Controllers\Admin\MABController;
use App\Http\Controllers\Doctor\DoctorEventController;
use App\Http\Controllers\Volunteer\VolunteerEventController;
use App\Http\Controllers\Support\TodoController as SupportTodoController;
use App\Http\Controllers\Support\CategoryController as SupportCategoryController;
use App\Http\Controllers\Volunteer\TodoController as VolunteerTodoController;

/*
|--------------------------------------------------------------------------
| Public / Home
|--------------------------------------------------------------------------
*/

Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/videos', [HomeController::class, 'videos'])->name('videos.index');
Route::get('/updates', [HomeController::class, 'updates'])->name('updates.index');
// Public update detail (by slug)
Route::get('/updates/{slug}', [HomeController::class, 'showUpdate'])->name('updates.show');
Route::get('/brand-ambassador/samantha-ruth', [HomeController::class, 'samantha'])->name('samantha');

Route::get('/patient-stories', [PatientStoryController::class, 'index'])->name('patient-stories.index');
Route::get('/patient-stories/{story:slug}', [PatientStoryController::class, 'show'])->name('patient-stories.show');

Route::get('/events', [EventController::class, 'index'])->name('events.index');
Route::get('/events/{event:slug}', [EventController::class, 'show'])->name('events.show');

// MAB Public Routes
Route::get('/medical-advisory-board', [App\Http\Controllers\MabFrontendController::class, 'index'])->name('mab.public.index');
Route::get('/medical-advisory-board/{mab}/{slug?}', [App\Http\Controllers\MabFrontendController::class, 'show'])->name('mab.public.show');
Route::get('/gallery', [App\Http\Controllers\GalleryFrontendController::class, 'index'])->name('gallery.public.index');


// UI demo: Registration loading screen
Route::get('/demo/registration-loading', function () {
    return view('auth.registration-loading-demo');
})->name('demo.registration.loading');



/*
|--------------------------------------------------------------------------
| Auth: Login / Logout
|--------------------------------------------------------------------------
*/

Route::get('/login', [LoginController::class, 'showLoginForm'])
    ->name('login');

Route::post('/login', [LoginController::class, 'login'])
    ->name('login.post');

Route::post('/logout', [LoginController::class, 'logout'])
    ->name('logout')
    ->middleware('auth');



/*
|--------------------------------------------------------------------------
| Registration (role-based)
|--------------------------------------------------------------------------
*/

// Role selection page
Route::get('/register', [RegistrationController::class, 'showRoleSelection'])
    ->name('register.role');

// ✅ Thank You page after registration
Route::get('/register/thank-you', [RegistrationController::class, 'showThankYou'])
    ->name('register.thankyou');

// Patient
Route::get('/register/patient', [RegistrationController::class, 'showPatientForm'])
    ->name('register.patient');

Route::post('/register/patient', [RegistrationController::class, 'registerPatient'])
    ->name('register.patient.submit');

// Doctor / Healthcare Professional
Route::get('/register/doctor', [RegistrationController::class, 'showDoctorForm'])
    ->name('register.doctor');

Route::post('/register/doctor', [RegistrationController::class, 'registerDoctor'])
    ->name('register.doctor.submit');

// Volunteer
Route::get('/register/volunteer', [RegistrationController::class, 'showVolunteerForm'])
    ->name('register.volunteer');

Route::post('/register/volunteer', [RegistrationController::class, 'registerVolunteer'])
    ->name('register.volunteer.submit');

/*
|--------------------------------------------------------------------------
| Dashboards (Role-based)
|--------------------------------------------------------------------------
*/

Route::middleware(['auth', 'role:admin'])->group(function () {
    Route::get('/admin/dashboard', [AdminDashboardController::class, 'index'])
        ->name('admin.dashboard');

    Route::get('/registrations/pending', [AdminRegistrationApprovalController::class, 'index'])
        ->name('admin.registrations.pending');

    Route::post('/registrations/{user}/approve', [AdminRegistrationApprovalController::class, 'approve'])
        ->name('admin.registrations.approve');

    Route::delete('/registrations/{user}', [AdminRegistrationApprovalController::class, 'destroy'])
        ->name('admin.registrations.destroy');

    // Admin user management: approved lists + export
    Route::get('/users/{role}', [AdminUserController::class, 'index'])
        ->where('role', 'patient|doctor|volunteer|support|seo')
        ->name('admin.users.index');

    Route::get('/users/{role}/export', [AdminUserController::class, 'export'])
        ->where('role', 'patient|doctor|volunteer|support|seo')
        ->name('admin.users.export');

    Route::resource('youtube-videos', YouTubeVideoController::class)->names('admin.youtube');
    // (Team admin routes removed)
    // Use an admin-prefixed URL to avoid colliding with the public `/updates` routes
    Route::resource('admin/updates', LatestUpdateController::class)->names('admin.updates')->except(['show']);


    Route::resource('admin/patient-stories', PatientStoryAdminController::class)->names('admin.patient-stories')->except(['show']);
    
    Route::resource('admin/events', EventAdminController::class)->names('admin.events')->except(['show']);


    //MAB Members Routes
    Route::resource('admin/mab-sessions', \App\Http\Controllers\Admin\MabSessionController::class)->names('admin.mab-sessions');
    Route::resource('admin/mab', MABController::class)->names('admin.mab');
    Route::resource('admin/gallery', \App\Http\Controllers\Admin\GalleryController::class)->names('admin.gallery');
});






Route::middleware(['auth', 'role:support'])->group(function () {
    Route::get('/support/dashboard', [SupportDashboardController::class, 'index'])
        ->name('support.dashboard');

    // Support: Todo management
    Route::resource('/support/todos', SupportTodoController::class)->names('support.todos');
    Route::post('/support/todos/{todo}/assign', [SupportTodoController::class, 'assign'])
        ->name('support.todos.assign');
    Route::get('/support/volunteers/search', [SupportTodoController::class, 'searchVolunteers'])
        ->name('support.volunteers.search');

    // Support: Categories
    Route::resource('/support/categories', SupportCategoryController::class)->names('support.categories');
});

Route::middleware(['auth', 'role:volunteer'])->group(function () {
    Route::get('/volunteer/dashboard', [VolunteerDashboardController::class, 'index'])
        ->name('volunteer.dashboard');
    Route::get('/volunteer/events', [VolunteerEventController::class, 'index'])
        ->name('volunteer.events.index');

    // Volunteer Todos
    Route::get('/volunteer/todos', [VolunteerTodoController::class, 'index'])
        ->name('volunteer.todos.index');
    Route::get('/volunteer/todos/{todo}', [VolunteerTodoController::class, 'show'])
        ->name('volunteer.todos.show');
    Route::patch('/volunteer/todos/{todo}/status', [VolunteerTodoController::class, 'updateStatus'])
        ->name('volunteer.todos.status');
    Route::post('/volunteer/todos/{todo}/updates', [VolunteerTodoController::class, 'storeUpdate'])
        ->name('volunteer.todos.updates');
    Route::post('/volunteer/todos/{todo}/complete', [VolunteerTodoController::class, 'markDone'])
        ->name('volunteer.todos.complete');
});

Route::middleware(['auth', 'role:seo'])->group(function () {
    Route::get('/seo/dashboard', [SeoDashboardController::class, 'index'])
        ->name('seo.dashboard');
    Route::post('/seo/update', [SeoDashboardController::class, 'store'])
        ->name('seo.update');
});

Route::middleware(['auth', 'role:doctor'])->group(function () {
    Route::get('/doctor/dashboard', [DoctorDashboardController::class, 'index'])
        ->name('doctor.dashboard');
    Route::get('/doctor/events', [DoctorEventController::class, 'index'])->name('doctor.events.index');
});

Route::middleware(['auth', 'role:patient'])->group(function () {
    Route::get('/patient/dashboard', [PatientDashboardController::class, 'index'])
        ->name('patient.dashboard');
});

