<?php $__env->startSection('title', 'YouTube Videos'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-5xl mx-auto space-y-6">

    
    <section class="flex flex-col md:flex-row md:items-center md:justify-between gap-3">
        <div>
            <h1 class="text-xl font-semibold text-softTextMain">YouTube Videos</h1>
            <p class="text-xs text-softTextMute">
                Manage the videos shown on your homepage section and video page.
            </p>
        </div>
        <a href="<?php echo e(route('admin.youtube.create')); ?>"
           class="px-3 py-2 rounded-xl bg-softSky text-white text-xs font-medium hover:bg-softTeal transition">
            + Add Video
        </a>
    </section>

    
    <?php if(session('success')): ?>
        <div class="rounded-xl border border-emerald-200 bg-emerald-50 px-3 py-2 text-xs text-emerald-800">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    
    <section class="rounded-2xl border border-softBorder bg-softCard shadow-sm p-3 text-xs">
        <form method="GET" action="<?php echo e(route('admin.youtube.index')); ?>" class="flex flex-col md:flex-row md:items-center md:justify-between gap-3">
            <div class="flex items-center gap-2">
                <label class="text-[11px] text-softTextMute">Filter by language:</label>
                <div class="relative">
                    <input type="text"
                           id="langFilterInput"
                           placeholder="Search language..."
                           class="w-40 rounded-xl border border-softBorder bg-white/90 px-3 py-1.5 text-[11px] text-softTextMain focus:outline-none focus:ring-1 focus:ring-softSky focus:border-softSky">
                </div>
                <select name="language" id="langFilterSelect"
                        class="rounded-xl border border-softBorder bg-white/90 px-2 py-1.5 text-[11px] text-softTextMain focus:outline-none focus:ring-1 focus:ring-softSky focus:border-softSky">
                    <option value="">All languages</option>
                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($lang); ?>" <?php echo e(request('language') === $lang ? 'selected' : ''); ?>>
                            <?php echo e($lang); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="flex items-center gap-2">
                <button type="submit"
                        class="px-3 py-1.5 rounded-xl bg-softSky text-white text-[11px] font-medium hover:bg-softTeal transition">
                    Apply
                </button>
                <?php if(request()->has('language') && request('language') !== null && request('language') !== ''): ?>
                    <a href="<?php echo e(route('admin.youtube.index')); ?>"
                       class="text-[11px] text-softTextMute hover:underline">
                        Clear
                    </a>
                <?php endif; ?>
            </div>
        </form>
    </section>

    
    <section class="rounded-2xl border border-softBorder bg-softCard shadow-sm overflow-hidden text-xs">
        <div class="overflow-x-auto">
            <table class="min-w-full">
                <thead class="bg-softBg border-b border-softBorder text-[11px] uppercase tracking-[0.15em] text-softTextMute">
                    <tr>
                        <th class="px-4 py-3 text-left">ID</th>
                        <th class="px-4 py-3 text-left">Title</th>
                        <th class="px-4 py-3 text-left">Language</th>
                        <th class="px-4 py-3 text-left">YouTube ID</th>
                        <th class="px-4 py-3 text-left">Meta</th>
                        <th class="px-4 py-3 text-left">Featured</th>
                        <th class="px-4 py-3 text-left">Published</th>
                        <th class="px-4 py-3 text-right">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-softBorder">
                    <?php $__empty_1 = true; $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-slate-50/80">
                            <td class="px-4 py-3 text-softTextMain font-medium">
                                #<?php echo e($video->id); ?>

                            </td>
                            <td class="px-4 py-3 text-softTextMain">
                                <?php echo e($video->title); ?>

                            </td>
                            <td class="px-4 py-3 text-softTextMute">
                                <?php echo e($video->language ?? '—'); ?>

                            </td>
                            <td class="px-4 py-3 text-softTextMute">
                                <?php echo e($video->youtube_id); ?>

                            </td>
                            <td class="px-4 py-3 text-softTextMute">
                                <?php echo e($video->meta ?? '—'); ?>

                            </td>
                            <td class="px-4 py-3">
                                <?php if($video->is_featured): ?>
                                    <span class="inline-flex px-2 py-0.5 rounded-full bg-amber-50 border border-amber-200 text-[10px] text-amber-700">
                                        Featured
                                    </span>
                                <?php else: ?>
                                    <span class="text-[10px] text-softTextMute">—</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3">
                                <?php if($video->is_published): ?>
                                    <span class="inline-flex px-2 py-0.5 rounded-full bg-emerald-50 border border-emerald-200 text-[10px] text-emerald-700">
                                        Published
                                    </span>
                                <?php else: ?>
                                    <span class="inline-flex px-2 py-0.5 rounded-full bg-slate-100 border border-softBorder text-[10px] text-softTextMute">
                                        Hidden
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3 text-right">
                                <a href="<?php echo e(route('admin.youtube.edit', $video)); ?>"
                                   class="text-[11px] text-softSky hover:underline mr-2">
                                    Edit
                                </a>
                                <form action="<?php echo e(route('admin.youtube.destroy', $video)); ?>"
                                      method="POST"
                                      class="inline-block"
                                      onsubmit="return confirm('Delete this video?');">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit"
                                            class="text-[11px] text-rose-500 hover:underline">
                                        Delete
                                    </button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="px-4 py-6 text-center text-softTextMute text-[11px]">
                                No videos added yet. Click “Add Video” to start.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="px-4 py-3 border-t border-softBorder bg-white/80">
            <?php echo e($videos->links()); ?>

        </div>
    </section>
</div>


<script>
    (function(){
        const input = document.getElementById('langFilterInput');
        const select = document.getElementById('langFilterSelect');
        if (!input || !select) return;

        input.addEventListener('input', function(){
            const term = this.value.toLowerCase();
            Array.from(select.options).forEach(opt => {
                if (!opt.value) {
                    opt.hidden = false;
                    return;
                }
                opt.hidden = !opt.text.toLowerCase().includes(term);
            });
        });
    })();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\myositis\website\resources\views/admin/youtube/index.blade.php ENDPATH**/ ?>