<section class="py-20 bg-slate-50 relative overflow-hidden">
  
  <div class="absolute top-0 left-0 w-full h-px bg-gradient-to-r from-transparent via-slate-200 to-transparent"></div>
  
  <div class="container mx-auto px-4 max-w-7xl relative z-10">
    <!-- Section Header -->
    <div class="text-center mb-16">
      <span class="inline-block py-1 px-3 rounded-full bg-blue-50 text-blue-600 text-xs font-bold uppercase tracking-widest mb-4">
          Moments
      </span>
      <h2 class="text-4xl md:text-5xl font-extrabold text-slate-900 tracking-tight mb-4">Gallery</h2>
      <p class="text-lg text-slate-600 max-w-2xl mx-auto leading-relaxed">
        Visual stories from our events, conferences, and community gatherings.
      </p>
    </div>

    <!-- Gallery Grid (Masonry) -->
    <div class="columns-1 sm:columns-2 lg:columns-4 gap-4 space-y-4">
        <?php $__currentLoopData = $gallery->take(8); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="group relative overflow-hidden rounded-2xl bg-slate-900 shadow-md cursor-pointer break-inside-avoid transform transition-all duration-300 hover:shadow-2xl hover:-translate-y-1">
            <img 
              loading="lazy"
              src="<?php echo e(asset('storage/' . $item->image)); ?>" 
              alt="<?php echo e($item->title ?? 'Gallery Image'); ?>" 
              class="w-full h-auto object-cover opacity-90 transition-transform duration-700 group-hover:scale-110 group-hover:opacity-100"
            >
            
            
            <div class="absolute inset-0 bg-slate-900/60 opacity-0 group-hover:opacity-100 transition-opacity duration-300 backdrop-blur-[2px]"></div>

            
            <div class="absolute inset-0 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-all duration-300 gap-4 transform translate-y-4 group-hover:translate-y-0">
                
                <button 
                    onclick="openLightbox('<?php echo e(asset('storage/' . $item->image)); ?>', '<?php echo e($item->title); ?>')"
                    class="w-12 h-12 rounded-full bg-white text-slate-900 flex items-center justify-center hover:bg-blue-600 hover:text-white transition-colors duration-300 shadow-lg"
                    title="Zoom View">
                    <i class="fa-solid fa-magnifying-glass-plus text-lg"></i>
                </button>

                
                <a href="<?php echo e(asset('storage/' . $item->image)); ?>" 
                   download="<?php echo e($item->title ? \Illuminate\Support\Str::slug($item->title) : 'gallery-image'); ?>"
                   class="w-12 h-12 rounded-full bg-white text-slate-900 flex items-center justify-center hover:bg-emerald-600 hover:text-white transition-colors duration-300 shadow-lg"
                   title="Download Image"
                   onclick="event.stopPropagation();">
                    <i class="fa-solid fa-download text-lg"></i>
                </a>
            </div>

            
            <?php if($item->title): ?>
            <div class="absolute bottom-0 left-0 right-0 p-6 translate-y-full group-hover:translate-y-0 transition-transform duration-300 delay-75">
                <p class="text-white font-medium text-sm truncate"><?php echo e($item->title); ?></p>
            </div>
            <?php endif; ?>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    
    <?php if($gallery->isEmpty()): ?>
        <div class="text-center py-20 bg-white rounded-3xl border border-dashed border-slate-300">
             <i class="fa-regular fa-image text-4xl text-slate-300 mb-4"></i>
            <p class="text-slate-500 font-medium">No images available yet.</p>
        </div>
    <?php endif; ?>

    
    <div class="mt-16 text-center">
        <a href="<?php echo e(route('gallery.public.index')); ?>" class="inline-flex items-center gap-2 text-sm font-bold text-slate-900 hover:text-blue-600 transition-colors uppercase tracking-widest border-b-2 border-slate-200 hover:border-blue-600 pb-1">
            View Full Gallery
            <i class="fa-solid fa-arrow-right-long"></i>
        </a>
    </div>

  </div>
</section>


<div id="gallery-lightbox" class="fixed inset-0 z-[100] bg-slate-900/95 hidden items-center justify-center p-4 backdrop-blur-sm transition-all duration-300 opacity-0 pointer-events-none">
    
    <button onclick="closeLightbox()" class="absolute top-6 right-6 text-white/70 hover:text-white transition-colors">
        <i class="fa-solid fa-xmark text-4xl"></i>
    </button>

    
    <div class="relative max-w-5xl max-h-[90vh] w-full flex flex-col items-center">
        <img id="lightbox-img" src="" class="max-w-full max-h-[85vh] object-contain rounded-lg shadow-2xl">
        <p id="lightbox-caption" class="text-white/80 mt-4 text-center text-lg font-medium"></p>
    </div>
</div>

<script>
    function openLightbox(src, title) {
        const modal = document.getElementById('gallery-lightbox');
        const img = document.getElementById('lightbox-img');
        const caption = document.getElementById('lightbox-caption');

        img.src = src;
        caption.textContent = title || '';
        
        modal.classList.remove('hidden', 'opacity-0', 'pointer-events-none');
        modal.classList.add('flex', 'opacity-100', 'pointer-events-auto');
        document.body.style.overflow = 'hidden'; // Prevent scrolling
    }

    function closeLightbox() {
        const modal = document.getElementById('gallery-lightbox');
        modal.classList.add('opacity-0', 'pointer-events-none');
        modal.classList.remove('opacity-100', 'pointer-events-auto');
        
        setTimeout(() => {
            modal.classList.add('hidden');
            modal.classList.remove('flex');
            document.body.style.overflow = ''; // Restore scrolling
        }, 300);
    }

    // Close on click outside
    document.getElementById('gallery-lightbox').addEventListener('click', function(e) {
        if (e.target === this) {
            closeLightbox();
        }
    });

    // Close on Escape key
    document.addEventListener('keydown', function(event) {
        if (event.key === "Escape") {
            closeLightbox();
        }
    });
</script><?php /**PATH E:\myositis\website\resources\views/sections/gallery.blade.php ENDPATH**/ ?>