<?php $__env->startSection('content'); ?>
<div class="max-w-6xl mx-auto">
    <div class="flex items-center justify-between mb-6">
        <h1 class="text-xl font-semibold text-softTextMain">
            Patient Stories
        </h1>
        <a href="<?php echo e(route('admin.patient-stories.create')); ?>"
           class="px-4 py-2 rounded-full text-sm font-semibold text-white"
           style="background: var(--brand-gradient);">
            + Add Story
        </a>
    </div>

    <?php if(session('success')): ?>
        <div class="mb-4 px-4 py-3 rounded bg-emerald-100 text-emerald-800 border border-emerald-200">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <div class="bg-softCard rounded-xl shadow-sm border border-softBorder overflow-hidden">
        <table class="min-w-full text-sm">
            <thead class="bg-softBg border-b border-softBorder">
                <tr>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Order</th>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Image</th>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Name</th>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Title</th>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Slug</th>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Published</th>
                    <th class="px-4 py-3 text-right font-semibold text-softTextMute">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $stories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $story): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="border-b border-softBorder last:border-0">
                        <td class="px-4 py-3 align-top">
                            <span class="inline-flex items-center justify-center w-8 h-8 rounded-full bg-softSky/10 text-softSky font-semibold text-xs">
                                <?php echo e($story->display_order); ?>

                            </span>
                        </td>
                        <td class="px-4 py-3">
                            <?php if($story->image_path): ?>
                                <img src="<?php echo e(asset($story->image_path)); ?>"
                                     alt="<?php echo e($story->title); ?>"
                                     class="w-14 h-14 object-cover rounded-md border border-softBorder">
                            <?php else: ?>
                                <span class="text-xs text-softTextMute">No image</span>
                            <?php endif; ?>
                        </td>
                        <td class="px-4 py-3 align-top">
                            <div class="font-medium text-softTextMain"><?php echo e($story->name); ?></div>
                            <?php if($story->condition): ?>
                                <div class="text-xs text-softTextMute"><?php echo e($story->condition); ?></div>
                            <?php endif; ?>
                        </td>
                        <td class="px-4 py-3 align-top">
                            <div class="text-softTextMain text-sm">
                                <?php echo e(Str::limit($story->title, 60)); ?>

                            </div>
                        </td>
                        <td class="px-4 py-3 align-top">
                            <span class="text-xs text-softTextMute"><?php echo e($story->slug); ?></span>
                        </td>
                        <td class="px-4 py-3 align-top">
                            <?php if($story->is_published): ?>
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-[11px] font-medium bg-emerald-100 text-emerald-700">
                                    Published
                                </span>
                            <?php else: ?>
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-[11px] font-medium bg-slate-100 text-slate-600">
                                    Draft
                                </span>
                            <?php endif; ?>
                        </td>
                        <td class="px-4 py-3 align-top text-right space-x-2">
                            <a href="<?php echo e(route('admin.patient-stories.edit', $story)); ?>"
                               class="inline-flex items-center px-3 py-1.5 rounded-full text-[11px] font-semibold border border-softBorder text-softTextMain hover:bg-softBg">
                                Edit
                            </a>

                            <form action="<?php echo e(route('admin.patient-stories.destroy', $story)); ?>"
                                  method="POST"
                                  class="inline-block"
                                  onsubmit="return confirm('Delete this story?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button
                                    class="inline-flex items-center px-3 py-1.5 rounded-full text-[11px] font-semibold bg-red-500 text-white hover:bg-red-600">
                                    Delete
                                </button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td class="px-4 py-4 text-center text-softTextMute text-sm" colspan="7">
                            No patient stories found. Click "Add Story" to create one.
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        <?php echo e($stories->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\myositis\website\resources\views/admin/patient-stories/index.blade.php ENDPATH**/ ?>