

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto">
    <div class="flex items-center justify-between mb-6">
        <h1 class="text-xl font-semibold text-softTextMain">
            Events Management
        </h1>
        <a href="<?php echo e(route('admin.events.create')); ?>"
           class="px-4 py-2 rounded-full text-sm font-semibold text-white"
           style="background: var(--brand-gradient);">
            + Add Event
        </a>
    </div>

    <?php if(session('success')): ?>
        <div class="mb-4 px-4 py-3 rounded bg-emerald-100 text-emerald-800 border border-emerald-200">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    
    <div class="mb-4 flex gap-2">
        <a href="<?php echo e(route('admin.events.index', ['filter' => 'all'])); ?>"
           class="px-4 py-2 rounded-lg text-sm font-semibold <?php echo e($filter === 'all' ? 'bg-softSky text-white' : 'bg-softBg text-softTextMute'); ?>">
            All Events
        </a>
        <a href="<?php echo e(route('admin.events.index', ['filter' => 'upcoming'])); ?>"
           class="px-4 py-2 rounded-lg text-sm font-semibold <?php echo e($filter === 'upcoming' ? 'bg-blue-500 text-white' : 'bg-softBg text-softTextMute'); ?>">
            Upcoming
        </a>
        <a href="<?php echo e(route('admin.events.index', ['filter' => 'live'])); ?>"
           class="px-4 py-2 rounded-lg text-sm font-semibold <?php echo e($filter === 'live' ? 'bg-red-500 text-white' : 'bg-softBg text-softTextMute'); ?>">
            Live
        </a>
        <a href="<?php echo e(route('admin.events.index', ['filter' => 'done'])); ?>"
           class="px-4 py-2 rounded-lg text-sm font-semibold <?php echo e($filter === 'done' ? 'bg-gray-500 text-white' : 'bg-softBg text-softTextMute'); ?>">
            Completed
        </a>
    </div>

    <div class="bg-softCard rounded-xl shadow-sm border border-softBorder overflow-hidden">
        <table class="min-w-full text-sm">
            <thead class="bg-softBg border-b border-softBorder">
                <tr>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Order</th>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Image</th>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Event Details</th>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Date & Time</th>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Status</th>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Published</th>
                    <th class="px-4 py-3 text-right font-semibold text-softTextMute">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="border-b border-softBorder last:border-0">
                        <td class="px-4 py-3 align-top">
                            <span class="inline-flex items-center justify-center w-8 h-8 rounded-full bg-softSky/10 text-softSky font-semibold text-xs">
                                <?php echo e($event->display_order); ?>

                            </span>
                        </td>
                        <td class="px-4 py-3">
                            <?php if($event->image_path): ?>
                                <img src="<?php echo e(asset($event->image_path)); ?>"
                                     alt="<?php echo e($event->title); ?>"
                                     class="w-20 h-14 object-cover rounded-md border border-softBorder">
                            <?php else: ?>
                                <div class="w-20 h-14 bg-softBg rounded-md flex items-center justify-center">
                                    <span class="text-xs text-softTextMute">No image</span>
                                </div>
                            <?php endif; ?>
                        </td>
                        <td class="px-4 py-3 align-top">
                            <div class="font-medium text-softTextMain"><?php echo e(Str::limit($event->title, 50)); ?></div>
                    
                        </td>
                        
                        <td class="px-4 py-3 align-top">
                            <div class="text-xs text-softTextMain"><?php echo e($event->start_datetime->format('M d, Y')); ?></div>
                            <div class="text-xs text-softTextMute"><?php echo e($event->start_datetime->format('g:i A')); ?></div>
                        </td>
                        <td class="px-4 py-3 align-top">
                            <?php echo $event->status_badge; ?>

                        </td>
                        <td class="px-4 py-3 align-top">
                            <?php if($event->is_published): ?>
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-emerald-100 text-emerald-700">
                                    Published
                                </span>
                            <?php else: ?>
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-slate-100 text-slate-600">
                                    Draft
                                </span>
                            <?php endif; ?>
                        </td>
                        <td class="px-4 py-3 align-top text-right space-x-2">
                            <a href="<?php echo e(route('admin.events.edit', $event)); ?>"
                               class="inline-flex items-center px-3 py-1.5 rounded-full text-xs font-semibold border border-softBorder text-softTextMain hover:bg-softBg">
                                Edit
                            </a>

                            <form action="<?php echo e(route('admin.events.destroy', $event)); ?>"
                                  method="POST"
                                  class="inline-block"
                                  onsubmit="return confirm('Delete this event?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button
                                    class="inline-flex items-center px-3 py-1.5 rounded-full text-xs font-semibold bg-red-500 text-white hover:bg-red-600">
                                    Delete
                                </button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td class="px-4 py-4 text-center text-softTextMute text-sm" colspan="8">
                            No events found. Click "Add Event" to create one.
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        <?php echo e($events->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\myositis\website\resources\views/admin/events/index.blade.php ENDPATH**/ ?>