<footer
    class="mt-16 text-sm"
    style="
        background:
          radial-gradient(900px 500px at -10% 0%, rgba(0,150,214,.25) 0%, transparent 60%),
          radial-gradient(900px 500px at 110% 0%, rgba(109,190,69,.22) 0%, transparent 60%),
          #020617;
        color:#e5e7eb;
    "
>
    
    <div class="h-1" style="background: var(--brand-gradient);"></div>

    
    <div class="max-w-6xl mx-auto px-4 sm:px-6 py-10 lg:py-12 grid gap-8 lg:gap-10
                md:grid-cols-2 lg:grid-cols-4">

        
        <div class="space-y-4">
            <div class="flex items-center gap-2">
                
                <div class="h-9 w-9 rounded-2xl flex items-center justify-center text-xs font-extrabold tracking-tight text-white"
                     style="background: var(--brand-gradient);">
                    MI
                </div>
                <div>
                    <div class="gradient-text text-lg leading-none">Myositis India</div>
                    <p class="text-[11px] text-gray-300 mt-1">
                        A unit of Madalasa Foundation
                    </p>
                </div>
            </div>

            <p class="text-[13px] text-gray-300 leading-relaxed">
                A patient-led initiative working to improve awareness, early diagnosis,
                and holistic support for people living with myositis across India.
            </p>

            <div class="flex items-center gap-2 text-[11px] text-gray-400">
                <span class="h-2 w-2 rounded-full bg-emerald-400 animate-pulse"></span>
                <span>Committed to patient-centred care &amp; evidence-based information.</span>
            </div>
        </div>

        
        <div>
            <h3 class="text-[13px] font-semibold tracking-[0.16em] uppercase text-gray-300 mb-3">
                For Patients &amp; Families
            </h3>
            <ul class="space-y-2 text-[13px] text-gray-300">
                <li><a href="#"
                       class="hover:text-[var(--brand-blue)] transition-colors">One-to-one patient support</a></li>
                <li><a href="#"
                       class="hover:text-[var(--brand-blue)] transition-colors">Join support groups</a></li>
                <li><a href="#"
                       class="hover:text-[var(--brand-blue)] transition-colors">Patient stories</a></li>
                <li><a href="#"
                       class="hover:text-[var(--brand-blue)] transition-colors">FAQs about myositis</a></li>
            </ul>
        </div>

        
        <div>
            <h3 class="text-[13px] font-semibold tracking-[0.16em] uppercase text-gray-300 mb-3">
                For Healthcare &amp; Community
            </h3>
            <ul class="space-y-2 text-[13px] text-gray-300">
                <li><a href="#"
                       class="hover:text-[var(--brand-blue)] transition-colors">HCP resources &amp; webinars</a></li>
                <li><a href="#"
                       class="hover:text-[var(--brand-blue)] transition-colors">Clinical research &amp; trials</a></li>
                <li><a href="#"
                       class="hover:text-[var(--brand-blue)] transition-colors">Volunteer with us</a></li>
                <li><a href="#"
                       class="hover:text-[var(--brand-blue)] transition-colors">Partner / sponsor programmes</a></li>
            </ul>
        </div>

        
        <div class="space-y-4">
            <h3 class="text-[13px] font-semibold tracking-[0.16em] uppercase text-gray-300">
                Stay Connected
            </h3>

            
            <div class="space-y-1 text-[13px] text-gray-300">
                <p>
                    <i class="fa-solid fa-envelope text-xs mr-2 text-[var(--brand-blue)]"></i>
                    <a href="mailto:info@myositisindia.org"
                       class="hover:text-[var(--brand-blue)]">info@myositisindia.org</a>
                </p>
                <p>
                    <i class="fa-solid fa-phone text-xs mr-2 text-[var(--brand-blue)]"></i>
                    <a href="tel:+91-0000000000" class="hover:text-[var(--brand-blue)]">+91-XXXXXXXXXX</a>
                </p>
                <p class="flex items-start gap-2">
                    <i class="fa-solid fa-location-dot text-xs mt-[3px] text-[var(--brand-blue)]"></i>
                    <span>India (online patient support nationwide)</span>
                </p>
            </div>

            
            <div class="mt-3">
                <p class="text-[12px] text-gray-400 mb-2">
                    Get updates on webinars, support groups and new resources.
                </p>
                <form action="#" method="post" class="flex flex-col sm:flex-row gap-2">
                    <input type="email" name="newsletter_email"
                           class="w-full sm:flex-1 px-3 py-2 rounded-lg border border-slate-600 bg-slate-900/60
                                  text-[13px] placeholder:text-gray-500 focus:outline-none focus:ring-1
                                  focus:ring-[var(--brand-blue)] focus:border-[var(--brand-blue)]"
                           placeholder="Enter your email">
                    <button type="submit"
                            class="px-4 py-2 rounded-lg text-[12px] font-semibold text-white
                                   whitespace-nowrap"
                            style="background: var(--brand-gradient);">
                        Subscribe
                    </button>
                </form>
            </div>

            
            <div class="flex items-center gap-3 pt-1">
                <a href="#" class="h-8 w-8 rounded-full flex items-center justify-center
                                  bg-slate-900/70 border border-slate-600 text-xs hover:text-white hover:border-[var(--brand-blue)]"
                   aria-label="WhatsApp">
                    <i class="fa-brands fa-whatsapp"></i>
                </a>
                <a href="#" class="h-8 w-8 rounded-full flex items-center justify-center
                                  bg-slate-900/70 border border-slate-600 text-xs hover:text-white hover:border-[var(--brand-blue)]"
                   aria-label="YouTube">
                    <i class="fa-brands fa-youtube"></i>
                </a>
                <a href="#" class="h-8 w-8 rounded-full flex items-center justify-center
                                  bg-slate-900/70 border border-slate-600 text-xs hover:text-white hover:border-[var(--brand-blue)]"
                   aria-label="Facebook">
                    <i class="fa-brands fa-facebook-f"></i>
                </a>
                <a href="#" class="h-8 w-8 rounded-full flex items-center justify-center
                                  bg-slate-900/70 border border-slate-600 text-xs hover:text-white hover:border-[var(--brand-blue)]"
                   aria-label="LinkedIn">
                    <i class="fa-brands fa-linkedin-in"></i>
                </a>
            </div>
        </div>
    </div>

    
    <div class="border-t border-slate-800/80">
        <div class="max-w-6xl mx-auto px-4 sm:px-6 py-4 flex flex-col md:flex-row items-center justify-between gap-3 text-[11px] text-gray-400">
            <p>
                © <?php echo e(date('Y')); ?> Myositis India · A unit of Madalasa Foundation. All rights reserved.
            </p>
            <div class="flex flex-wrap items-center gap-3">
                <a href="#" class="hover:text-[var(--brand-blue)]">Privacy Policy</a>
                <span class="hidden md:inline-block">•</span>
                <a href="#" class="hover:text-[var(--brand-blue)]">Terms of Use</a>
                <span class="hidden md:inline-block">•</span>
                <a href="#" class="hover:text-[var(--brand-blue)]">Disclaimer (Medical)</a>
            </div>
        </div>
    </div>
</footer>
<?php /**PATH E:\myositis\website\resources\views/components/footer.blade.php ENDPATH**/ ?>