<div class="bg-white rounded shadow p-4">
    <div class="grid grid-cols-1 gap-4">
        <div>
            <label class="block text-sm font-medium">Title</label>
            <input name="title" value="<?php echo e(old('title', optional($todo)->title)); ?>" class="mt-1 block w-full border rounded p-2" required />
            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="text-red-600 text-sm"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div>
            <label class="block text-sm font-medium">Description</label>
            <textarea name="description" class="mt-1 block w-full border rounded p-2" rows="6"><?php echo e(old('description', optional($todo)->description)); ?></textarea>
            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="text-red-600 text-sm"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="grid grid-cols-2 gap-4">
            <div>
                <label class="block text-sm font-medium">Category</label>
                <select name="category_id" class="mt-1 block w-full border rounded p-2">
                    <option value="">Uncategorized</option>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($cat->id); ?>" <?php echo e(old('category_id', optional($todo)->category_id) == $cat->id ? 'selected' : ''); ?>><?php echo e($cat->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div>
                <label class="block text-sm font-medium">Priority</label>
                <select name="priority" class="mt-1 block w-full border rounded p-2">
                    <option value="low" <?php echo e(old('priority', optional($todo)->priority) == 'low' ? 'selected' : ''); ?>>Low</option>
                    <option value="medium" <?php echo e(old('priority', optional($todo)->priority) == 'medium' ? 'selected' : ''); ?>>Medium</option>
                    <option value="high" <?php echo e(old('priority', optional($todo)->priority) == 'high' ? 'selected' : ''); ?>>High</option>
                    <option value="urgent" <?php echo e(old('priority', optional($todo)->priority) == 'urgent' ? 'selected' : ''); ?>>Urgent</option>
                </select>
            </div>
        </div>

        <div class="grid grid-cols-2 gap-4">
            <div>
                <label class="block text-sm font-medium">Due date</label>
                <input type="date" name="due_date" value="<?php echo e(old('due_date', optional(optional($todo)->due_date)->format('Y-m-d') ?? '')); ?>" class="mt-1 block w-full border rounded p-2" />
            </div>

            <div x-data="{ q: '', results: [] }" x-init="() => {}" class="">
                <label class="block text-sm font-medium">Assign volunteers</label>
                <input x-model="q" @input.debounce.300ms="
                    if (q.length > 1) fetch('/support/volunteers/search?q='+encodeURIComponent(q))
                        .then(r => r.json()).then(rs => results = rs)
                " type="text" placeholder="Search volunteers..." class="mt-1 block w-full border rounded p-2" />

                <div class="mt-2">
                    <template x-for="r in results" :key="r.id">
                        <div class="flex items-center gap-2 py-1">
                            <input type="checkbox" :value="r.id" name="assignees[]"> <span x-text="r.name + ' ('+ (r.email || r.phone) +')'"></span>
                        </div>
                    </template>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH E:\myositis\website\resources\views/support/todos/_form.blade.php ENDPATH**/ ?>