<?php $__env->startSection('title', 'Add Latest Update'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-lg mx-auto space-y-6">
    <section>
        <h1 class="text-xl font-semibold text-softTextMain">Add Latest Update</h1>
        <p class="text-xs text-softTextMute">
            Short announcements that will show in the homepage “Latest Updates” strip.
        </p>
    </section>

    <section class="rounded-2xl border border-softBorder bg-softCard shadow-sm p-4 text-xs space-y-3">
        <form action="<?php echo e(route('admin.updates.store')); ?>" method="POST" class="space-y-3">
            <?php echo csrf_field(); ?>

            <div>
                <label class="block text-[11px] font-medium text-softTextMute mb-1">
                    Title <span class="text-rose-500">*</span>
                </label>
                <input type="text" name="title" value="<?php echo e(old('title')); ?>"
                       class="w-full rounded-xl border border-softBorder bg-white/90 px-3 py-2 text-xs text-softTextMain focus:outline-none focus:ring-1 focus:ring-softSky focus:border-softSky">
                <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-[10px] text-rose-500 mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div>
                <label class="block text-[11px] font-medium text-softTextMute mb-1">
                    Category
                </label>
                <select name="category"
                        class="w-full rounded-xl border border-softBorder bg-white/90 px-3 py-2 text-xs text-softTextMain focus:outline-none focus:ring-1 focus:ring-softSky focus:border-softSky">
                    <option value="">Select</option>
                    <?php $__currentLoopData = ['Announcement','Event','Research','Patient Story','Clinical Update','Platform Update']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($cat); ?>" <?php echo e(old('category') === $cat ? 'selected' : ''); ?>>
                            <?php echo e($cat); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-[10px] text-rose-500 mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div>
                <label class="block text-[11px] font-medium text-softTextMute mb-1">
                    Short summary (shown on homepage)
                </label>
                <textarea name="excerpt" rows="2"
                          class="w-full rounded-xl border border-softBorder bg-white/90 px-3 py-2 text-xs text-softTextMain focus:outline-none focus:ring-1 focus:ring-softSky focus:border-softSky"><?php echo e(old('excerpt')); ?></textarea>
                <?php $__errorArgs = ['excerpt'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-[10px] text-rose-500 mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div>
                <label class="block text-[11px] font-medium text-softTextMute mb-1">
                    Full details (optional, for later “Read more” page)
                </label>
                <textarea name="body" rows="4"
                          class="w-full rounded-xl border border-softBorder bg-white/90 px-3 py-2 text-xs text-softTextMain focus:outline-none focus:ring-1 focus:ring-softSky focus:border-softSky"><?php echo e(old('body')); ?></textarea>
                <?php $__errorArgs = ['body'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-[10px] text-rose-500 mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="flex items-center justify-between pt-2">
                <div class="flex items-center gap-3">
                    <label class="inline-flex items-center gap-2">
                        <input type="checkbox" name="is_published" value="1"
                               class="rounded border-softBorder text-softSky focus:ring-softSky"
                               <?php echo e(old('is_published', true) ? 'checked' : ''); ?>>
                        <span class="text-[11px] text-softTextMain">Published</span>
                    </label>

                    <label class="inline-flex items-center gap-2">
                        <input type="checkbox" name="is_pinned" value="1"
                               class="rounded border-softBorder text-softSky focus:ring-softSky"
                               <?php echo e(old('is_pinned') ? 'checked' : ''); ?>>
                        <span class="text-[11px] text-softTextMain">Pin to top</span>
                    </label>
                </div>

                <div class="flex items-center gap-2">
                    <a href="<?php echo e(route('admin.updates.index')); ?>"
                       class="text-[11px] text-softTextMute hover:underline">
                        Cancel
                    </a>
                    <button type="submit"
                            class="px-3 py-2 rounded-xl bg-softSky text-white text-xs font-medium hover:bg-softTeal transition">
                        Save Update
                    </button>
                </div>
            </div>
        </form>
    </section>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\myositis\website\resources\views/admin/updates/create.blade.php ENDPATH**/ ?>