

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <div class="sm:flex sm:items-center sm:justify-between">
        <div class="sm:flex-auto">
            <h1 class="text-2xl font-bold text-gray-900">Gallery</h1>
            <p class="mt-2 text-sm text-gray-700">Manage gallery images. Only WebP format is allowed.</p>
        </div>
        <div class="mt-4 sm:ml-16 sm:mt-0 sm:flex-none">
            <a href="<?php echo e(route('admin.gallery.create')); ?>" class="block rounded-md bg-indigo-600 px-3 py-2 text-center text-sm font-semibold text-white shadow-sm hover:bg-indigo-500">
                Upload New Image
            </a>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="rounded-md bg-green-50 p-4 border border-green-200">
            <p class="text-sm font-medium text-green-800"><?php echo e(session('success')); ?></p>
        </div>
    <?php endif; ?>

    <div class="overflow-hidden bg-white shadow sm:rounded-lg border border-gray-200">
        <div class="px-4 py-5 sm:px-6 border-b border-gray-200">
            <h3 class="text-base font-semibold leading-6 text-gray-900">Images List</h3>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-300">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="py-3.5 pl-4 pr-3 text-left text-sm font-semibold text-gray-900">Image</th>
                        <th class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900">Title</th>
                        <th class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900">Active</th>
                        <th class="relative py-3.5 pl-3 pr-4 sm:pr-6"><span class="sr-only">Actions</span></th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200 bg-white">
                    <?php $__currentLoopData = $gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="whitespace-nowrap py-4 pl-4 pr-3 text-sm">
                            <img src="<?php echo e(asset('storage/' . $item->image)); ?>" class="h-16 w-16 object-cover rounded-md bg-gray-100">
                        </td>
                        <td class="whitespace-nowrap px-3 py-4 text-sm font-medium text-gray-900"><?php echo e($item->title ?? '-'); ?></td>

                        <td class="whitespace-nowrap px-3 py-4 text-sm">
                            <?php if($item->is_active): ?>
                                <span class="inline-flex rounded-full bg-green-100 px-2 text-xs font-semibold leading-5 text-green-800">Active</span>
                            <?php else: ?>
                                <span class="inline-flex rounded-full bg-red-100 px-2 text-xs font-semibold leading-5 text-red-800">Inactive</span>
                            <?php endif; ?>
                        </td>
                        <td class="relative whitespace-nowrap py-4 pl-3 pr-4 text-right text-sm font-medium sm:pr-6">
                            <a href="<?php echo e(route('admin.gallery.edit', $item->id)); ?>" class="text-indigo-600 hover:text-indigo-900 mr-4">Edit</a>
                            <form action="<?php echo e(route('admin.gallery.destroy', $item->id)); ?>" method="POST" class="inline-block" onsubmit="return confirm('Delete this image?');">
                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="text-red-600 hover:text-red-900">Delete</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\myositis\website\resources\views/admin/gallery/index.blade.php ENDPATH**/ ?>