<div class="bg-white border border-slate-200 rounded-xl shadow-sm p-5 mt-6">
    <div class="flex items-center justify-between mb-4">
        <div>
            <h3 class="text-sm font-bold text-slate-800">Upcoming Events</h3>
            <p class="text-xs text-slate-500">Webinars & Support Groups</p>
        </div>
        <a href="<?php echo e(route('events.index')); ?>" class="text-xs font-semibold text-blue-600 hover:text-blue-800">View all</a>
    </div>
    
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
        <?php $__empty_1 = true; $__currentLoopData = $upcomingEvents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="flex gap-4 p-3 rounded-lg border border-slate-100 hover:border-blue-200 hover:bg-blue-50/40 transition group">
                
                <div class="flex flex-col items-center justify-center w-12 h-12 rounded-lg bg-blue-50 text-blue-700 shrink-0">
                    <span class="text-[10px] uppercase font-bold"><?php echo e($event->month_name); ?></span>
                    <span class="text-lg font-bold leading-none"><?php echo e($event->day_number); ?></span>
                </div>
                
                <div class="flex-1 min-w-0">
                    <div class="flex items-center gap-2 mb-1">
                        <span class="inline-flex items-center px-1.5 py-0.5 rounded text-[10px] font-medium bg-slate-100 text-slate-600">
                            <?php echo e($event->event_mode); ?>

                        </span>
                        <?php if($event->status === 'live'): ?>
                            <span class="inline-flex items-center px-1.5 py-0.5 rounded text-[10px] font-medium bg-red-100 text-red-700 animate-pulse">
                                Live
                            </span>
                        <?php endif; ?>
                    </div>
                    
                    <h4 class="text-sm font-semibold text-slate-900 truncate group-hover:text-blue-600 transition-colors">
                        <a href="<?php echo e(route('events.show', $event)); ?>" class="hover:underline focus:outline-none">
                            <?php echo e($event->title); ?>

                        </a>
                    </h4>
                    <p class="text-xs text-slate-500 mt-0.5">
                        <?php echo e($event->start_datetime->format('g:i A')); ?>

                    </p>
                    
                    <div class="mt-2 flex items-center gap-3">
                        <a href="<?php echo e(route('events.show', $event)); ?>" class="text-xs font-medium text-blue-600 hover:text-blue-800">
                            Details
                        </a>
                        <?php if($event->meeting_link || $event->registration_link): ?>
                            <a href="<?php echo e($event->meeting_link ?? $event->registration_link); ?>" target="_blank" class="text-xs font-medium text-slate-600 hover:text-slate-900">
                                <?php echo e($event->status === 'live' ? 'Join Now' : 'Register'); ?>

                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-span-full text-center py-6 text-slate-500 text-sm">
                No upcoming events scheduled at the moment.
            </div>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH E:\myositis\website\resources\views/partials/dashboard-events.blade.php ENDPATH**/ ?>