<!-- ===== YOUTUBE VIDEO HUB – YouTube-style Red / Dark / White ===== -->
<style>
    .yt-wrap {
        margin: 42px 0;
        border-radius: 16px;
        overflow: hidden;
        background: linear-gradient(135deg, #181818, #202124);
        color: #f9fafb;
        box-shadow: 0 14px 40px rgba(0, 0, 0, .35);
    }

    .yt-inner {
        max-width: 1200px;
        margin: 0 auto;
        padding: 26px 20px 30px;
    }

    .yt-header {
        display: flex;
        flex-wrap: wrap;
        align-items: flex-start;
        justify-content: space-between;
        gap: 12px;
        margin-bottom: 16px;
    }

    .yt-title {
        margin: 0;
        font-weight: 900;
        font-size: 26px;
        display: flex;
        align-items: center;
        gap: 10px;
        color: #ffffff;
    }

    .yt-logo-dot {
        width: 26px;
        height: 18px;
        border-radius: 4px;
        background: #ff0000;
        position: relative;
        box-shadow: 0 6px 14px rgba(255, 0, 0, .45);
    }

    .yt-logo-dot::after {
        content: '';
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-40%, -50%);
        width: 0;
        height: 0;
        border-left: 7px solid #fff;
        border-top: 5px solid transparent;
        border-bottom: 5px solid transparent;
    }

    .yt-sub {
        color: #e5e7eb;
        font-weight: 500;
        font-size: 13px;
        margin-top: 4px;
        max-width: 540px;
    }

    .yt-actions {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
    }

    .yt-btn {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 8px 16px;
        border-radius: 999px;
        font-weight: 800;
        font-size: 12px;
        text-decoration: none;
        cursor: pointer;
        border: 1px solid transparent;
        transition:
            background .15s ease,
            color .15s ease,
            box-shadow .15s ease,
            transform .12s ease;
    }

    .yt-btn-primary {
        background: #ff0000;
        color: #ffffff;
        border-color: #ff0000;
        box-shadow: 0 8px 18px rgba(255, 0, 0, .45);
    }

    .yt-btn-primary span.icon {
        width: 0;
        height: 0;
        border-left: 8px solid #fff;
        border-top: 5px solid transparent;
        border-bottom: 5px solid transparent;
    }

    .yt-btn-primary:hover {
        background: #e60000;
        box-shadow: 0 10px 26px rgba(255, 0, 0, .55);
        transform: translateY(-1px);
    }

    .yt-btn-ghost {
        background: rgba(24, 24, 24, .96);
        color: #e5e7eb;
        border-color: #3f3f46;
    }

    .yt-btn-ghost span.icon {
        font-size: 14px;
    }

    .yt-btn-ghost:hover {
        background: #27272f;
        border-color: #52525b;
        transform: translateY(-1px);
    }

    .yt-grid {
        margin-top: 10px;
        display: grid;
        grid-template-columns: 2fr 1fr;
        gap: 16px;
    }

    /* Main player */
    .yt-main {
        border-radius: 12px;
        overflow: hidden;
        background: #000;
        border: 1px solid #27272f;
    }

    .yt-main iframe {
        width: 100%;
        aspect-ratio: 16/9;
        border: 0;
        display: block;
    }

    /* Playlist panel */
    .yt-list {
        display: grid;
        grid-template-columns: 1fr;
        gap: 10px;
        max-height: 360px;
        overflow-y: auto;
        padding-right: 4px;
    }

    .yt-list::-webkit-scrollbar {
        width: 6px;
    }

    .yt-list::-webkit-scrollbar-track {
        background: #111827;
    }

    .yt-list::-webkit-scrollbar-thumb {
        background: #4b5563;
        border-radius: 999px;
    }

    .yt-card {
        display: grid;
        grid-template-columns: 140px 1fr;
        gap: 8px;
        align-items: center;
        background: #18181b;
        border: 1px solid #27272f;
        border-radius: 12px;
        overflow: hidden;
        cursor: pointer;
        padding: 6px;
        transition:
            background .15s ease,
            border-color .15s ease,
            transform .12s ease,
            box-shadow .15s ease;
    }

    .yt-card:hover {
        background: #1f2937;
        border-color: #4b5563;
        transform: translateY(-1px);
        box-shadow: 0 6px 16px rgba(0, 0, 0, .45);
    }

    .yt-thumb {
        width: 100%;
        height: 100%;
        aspect-ratio: 16/9;
        background: #020617;
        object-fit: cover;
        display: block;
    }

    .yt-card h4 {
        margin: 0;
        color: #f9fafb;
        font-weight: 700;
        font-size: 13px;
        line-height: 1.35;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }

    .yt-card .meta {
        color: #d1d5db;
        font-weight: 500;
        font-size: 11px;
        opacity: .9;
        margin-top: 3px;
    }

    .yt-lang {
        color: #9ca3af;
        font-size: 11px;
        margin-top: 4px;
    }

    .yt-badge {
        display: inline-block;
        margin-top: 6px;
        padding: 4px 9px;
        border-radius: 999px;
        font-weight: 800;
        font-size: 10px;
        background: #ff0000;
        color: #ffffff;
    }

    .yt-badge.ghost {
        background: #111827;
        color: #e5e7eb;
        border: 1px solid #4b5563;
    }

    @media(max-width:980px) {
        .yt-grid {
            grid-template-columns: 1fr;
        }

        .yt-list {
            max-height: none;
        }
    }

    @media(max-width:640px) {
        .yt-inner {
            padding: 22px 14px 26px;
        }

        .yt-title {
            font-size: 22px;
        }
    }
</style>

<?php if($featured): ?>
    <section class="yt-wrap" aria-label="YouTube Video Hub">
        <div class="yt-inner">

            
            <div class="yt-header">
                <div>
                    <h2 class="yt-title">
                        <span class="yt-logo-dot"></span>
                        <span>Videos &amp; Webinars</span>
                    </h2>
                    <p class="yt-sub">
                        Latest from our Myositis India channel — educational talks, patient stories, and events.
                    </p>
                </div>

                <div class="yt-actions">
                    
                    <a href="<?php echo e(route('videos.index')); ?>" class="yt-btn yt-btn-primary">
                        <span class="icon"></span>
                        <span>View all videos</span>
                    </a>

                    
                    <a href="https://www.youtube.com/@myositis_india" target="_blank" rel="noopener"
                       class="yt-btn yt-btn-ghost">
                        <span class="icon">▶</span>
                        <span>Visit on YouTube</span>
                    </a>
                </div>
            </div>

            <div class="yt-grid" id="ytHub">
                <!-- Main player -->
                <div class="yt-main">
                    <iframe id="ytPlayer"
                            src="https://www.youtube.com/embed/<?php echo e($featured->youtube_id); ?>"
                            title="<?php echo e($featured->title); ?>" loading="lazy"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                            allowfullscreen></iframe>
                </div>

                <!-- Playlist cards (only 3 videos on right) -->
                <div class="yt-list">
                    
                    <article class="yt-card" data-vid="<?php echo e($featured->youtube_id); ?>">
                        <img class="yt-thumb"
                             src="https://i.ytimg.com/vi/<?php echo e($featured->youtube_id); ?>/hqdefault.jpg"
                             alt="<?php echo e($featured->title); ?>">
                        <div>
                            <h4><?php echo e($featured->title); ?></h4>
                            <div class="meta"><?php echo e($featured->meta ?? 'Featured video'); ?></div>
                            <?php if(!empty($featured->language)): ?>
                                <div class="yt-lang">Language: <?php echo e($featured->language); ?></div>
                            <?php endif; ?>
                            <span class="yt-badge">Featured</span>
                        </div>
                    </article>

                    
                    <?php $__currentLoopData = $playlist->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <article class="yt-card" data-vid="<?php echo e($video->youtube_id); ?>">
                            <img class="yt-thumb"
                                 src="https://i.ytimg.com/vi/<?php echo e($video->youtube_id); ?>/hqdefault.jpg"
                                 alt="<?php echo e($video->title); ?>">
                            <div>
                                <h4><?php echo e($video->title); ?></h4>
                                <div class="meta"><?php echo e($video->meta ?? 'YouTube video'); ?></div>
                                <?php if(!empty($video->language)): ?>
                                    <div class="yt-lang">Language: <?php echo e($video->language); ?></div>
                                <?php endif; ?>
                                <span class="yt-badge ghost">Watch next</span>
                            </div>
                        </article>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </section>

    <script>
        // Simple playlist switcher
        (function() {
            const hub = document.getElementById('ytHub');
            if (!hub) return;
            const player = hub.querySelector('#ytPlayer');

            hub.querySelectorAll('.yt-card').forEach(card => {
                card.addEventListener('click', () => {
                    const id = card.getAttribute('data-vid');
                    if (id) {
                        const base = 'https://www.youtube.com/embed/';
                        player.src = base + id;
                    }
                    window.scrollTo({
                        top: hub.offsetTop - 80,
                        behavior: 'smooth'
                    });
                });
            });
        })();
    </script>
<?php endif; ?>
<?php /**PATH E:\myositis\website\resources\views/sections/youtube.blade.php ENDPATH**/ ?>