<!doctype html>
<html lang="en" class="h-full bg-[#f3f4f6]">
<head>
    <meta charset="utf-8">
    <title><?php echo $__env->yieldContent('title', 'SEO Manager'); ?> | Myositis India</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex, nofollow">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; }
        .glass-nav { background: rgba(255, 255, 255, 0.9); backdrop-filter: blur(10px); }
        .sidebar-gradient { background: linear-gradient(180deg, #0f172a 0%, #1e293b 100%); }
    </style>
</head>
<body class="h-full antialiased text-slate-600 bg-[#f3f4f6]">

<div class="min-h-full flex">
    
    
    <div x-data="{ open: false }" class="lg:hidden">
    </div>

    
    <div class="hidden lg:fixed lg:inset-y-0 lg:flex lg:w-72 lg:flex-col sidebar-gradient border-r border-slate-700/50 shadow-2xl z-30">
        
        <div class="flex h-20 shrink-0 items-center px-6 border-b border-slate-700/50 bg-slate-900/50">
             <div class="flex items-center gap-3">
                <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-blue-600 shadow-lg shadow-blue-500/30 text-white font-bold tracking-tighter">
                    MI
                </div>
                <div>
                     <span class="block text-white font-bold text-base tracking-wide">Myositis</span>
                     <span class="block text-[10px] uppercase font-semibold text-slate-400 tracking-widest">SEO Console</span>
                </div>
            </div>
        </div>

        
        <div class="flex flex-1 flex-col overflow-y-auto px-4 py-6 custom-scrollbar">
            <nav class="space-y-1.5">
                
                <a href="<?php echo e(route('seo.dashboard')); ?>" 
                   class="group flex items-center gap-3 px-3 py-3 text-sm font-medium rounded-lg transition-all duration-200 
                   <?php echo e(request()->routeIs('seo.dashboard') ? 'bg-blue-600 text-white shadow-lg shadow-blue-900/50' : 'text-slate-400 hover:text-white hover:bg-white/5'); ?>">
                    <i class="fa-solid fa-magnifying-glass-chart w-5 text-center transition-colors <?php echo e(request()->routeIs('seo.dashboard') ? 'text-white' : 'text-slate-500 group-hover:text-white'); ?>"></i>
                    <span class="tracking-wide">SEO Dashboard</span>
                </a>

            </nav>
        </div>
        
        
        <div class="border-t border-slate-700/50 p-4 bg-slate-900/30">
            <div class="flex items-center gap-3 p-2 rounded-xl transition-colors hover:bg-white/5 cursor-pointer group">
                <div class="h-9 w-9 rounded-full bg-slate-700 flex items-center justify-center ring-2 ring-slate-600 group-hover:ring-blue-500 transition-all">
                    <span class="text-xs font-bold text-white"><?php echo e(substr(auth()->user()?->name ?? 'A', 0, 1)); ?></span>
                </div>
                <div class="flex-1 overflow-hidden">
                    <p class="truncate text-sm font-medium text-slate-200 group-hover:text-white"><?php echo e(auth()->user()?->name ?? 'SEO Admin'); ?></p>
                    <p class="truncate text-[10px] text-slate-500 group-hover:text-slate-400">seo@myositis.org</p>
                </div>
                <i class="fa-solid fa-sliders text-xs text-slate-600 group-hover:text-white transition-colors"></i>
            </div>
        </div>
    </div>

    
    <div class="flex flex-1 flex-col lg:pl-72 min-w-0 transition-all">
        
        <header class="sticky top-0 z-20 flex h-20 flex-shrink-0 items-center gap-x-4 border-b border-gray-200 glass-nav px-4 shadow-sm sm:gap-x-6 sm:px-6 lg:px-8">
            <button type="button" class="-m-2.5 p-2.5 text-gray-700 lg:hidden hover:text-blue-600 transition-colors">
                <span class="sr-only">Open sidebar</span>
                <i class="fa-solid fa-bars text-xl"></i>
            </button>
            <div class="flex flex-1 gap-x-4 self-stretch lg:gap-x-6">
                <div class="relative flex flex-1">
                     <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center">
                        <i class="fa-solid fa-magnifying-glass text-slate-400 text-sm"></i>
                    </div>
                    <input type="search" placeholder="Search pages..." class="block h-full w-full border-0 bg-transparent py-0 pl-8 pr-0 text-slate-600 placeholder:text-slate-400 focus:ring-0 text-sm font-medium">
                </div>
                <div class="flex items-center gap-x-4 lg:gap-x-6">
                    <button class="-m-2.5 p-2.5 text-slate-400 hover:text-blue-600 transition-colors">
                        <span class="sr-only">Notifications</span>
                         <i class="fa-regular fa-bell text-lg"></i>
                    </button>
                    <div class="hidden lg:block lg:h-6 lg:w-px lg:bg-slate-200" aria-hidden="true"></div>
                    
                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="text-xs font-bold text-slate-500 hover:text-red-600 transition-colors uppercase tracking-wider flex items-center gap-2">
                            <i class="fa-solid fa-power-off"></i> Logout
                        </button>
                    </form>
                </div>
            </div>
        </header>

        <main class="flex-1 py-10">
            <div class="px-4 sm:px-6 lg:px-8 max-w-[1920px] mx-auto">
                 <?php echo $__env->yieldContent('content'); ?>
            </div>
        </main>
    </div>
</div>

</body>
</html>
<?php /**PATH E:\myositis\website\resources\views/layouts/seo.blade.php ENDPATH**/ ?>