<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($seo?->title ?? 'Myositis India - Patient Care Foundation'); ?></title>
    
    <!-- Core SEO -->
    <meta name="description" content="<?php echo e($seo?->description ?? 'Official website of Myositis India - connecting patients, caregivers, and medical experts.'); ?>">
    <meta name="keywords" content="<?php echo e($seo?->keywords ?? 'myositis, india, autoimmune, health, patient care'); ?>">
    <meta name="robots" content="<?php echo e($seo?->robots ?? 'index, follow'); ?>">
    <link rel="canonical" href="<?php echo e($seo?->canonical_url ?? url()->current()); ?>">
    
    <!-- Open Graph (Facebook/Social) -->
    <meta property="og:type" content="<?php echo e($seo?->og_type ?? 'website'); ?>">
    <meta property="og:url" content="<?php echo e($seo?->canonical_url ?? url()->current()); ?>">
    <meta property="og:title" content="<?php echo e($seo?->og_title ?? ($seo?->title ?? 'Myositis India')); ?>">
    <meta property="og:description" content="<?php echo e($seo?->og_description ?? ($seo?->description ?? 'Patient care foundation')); ?>">
    <?php if($seo?->og_image): ?>
        <meta property="og:image" content="<?php echo e($seo->og_image); ?>">
    <?php endif; ?>
    
    <!-- Twitter Card -->
    <meta name="twitter:card" content="<?php echo e($seo?->twitter_card ?? 'summary_large_image'); ?>">
    <meta name="twitter:title" content="<?php echo e($seo?->twitter_title ?? ($seo?->title ?? 'Myositis India')); ?>">
    <meta name="twitter:description" content="<?php echo e($seo?->twitter_description ?? ($seo?->description ?? '')); ?>">
    <?php if($seo?->twitter_image): ?>
        <meta name="twitter:image" content="<?php echo e($seo->twitter_image); ?>">
    <?php endif; ?>
    
    <!-- Schema.org JSON-LD -->
    <?php if($seo?->schema_js): ?>
        <script type="application/ld+json">
            <?php echo json_encode($seo->schema_js, 15, 512) ?>
        </script>
    <?php endif; ?>
    <!-- Fonts & Icons (Bundled via Vite) -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <!-- Favicon & Manifest -->
    <link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
    <link rel="manifest" href="/site.webmanifest">
    
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?> 
</head>
<body class="bg-gray-50">
    <?php echo $__env->make('components.updatedheader', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('sections.pinned-updates', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <main class="container mx-auto px-4 py-8">
        <?php echo $__env->yieldContent('content'); ?>
    </main>
    <?php echo $__env->make('components.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
      <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH E:\myositis\website\resources\views/layouts/app.blade.php ENDPATH**/ ?>