<header class="bg-white shadow-sm relative z-50">
  <div class="site-bar"></div>

  <div class="container mx-auto px-4 py-4">
    <div class="flex flex-col md:flex-row items-center justify-between gap-4">
      <!-- Logo + Mobile Toggle -->
      <div class="flex items-center justify-between w-full md:w-auto">
        <a href="<?php echo e(url('/')); ?>" class="flex items-center">
          <span class="p-2 rounded-lg mr-3">
            <img src="<?php echo e(asset('assets/images/logo/myositisindialogo.webp')); ?>" width="64" height="64" alt="Myositis India Logo" class="rounded-lg" loading="lazy" decoding="async">
          </span>
          <span>
            <span class="text-xl font-black gradient-text leading-tight block">MYOSITIS INDIA</span>
            <span class="text-xs text-gray-600">Patient Care Foundation</span>
          </span>
        </a>

        <button id="mi-toggle" class="lg:hidden p-2 text-blue-800 hover:bg-blue-50 rounded-lg transition-colors" aria-label="Toggle menu" aria-expanded="false" aria-controls="mi-nav mi-mobile-buttons">
          <i class="fa-solid fa-bars text-2xl"></i>
        </button>
      </div>

      <!-- Search -->
      <div class="hidden lg:block flex-1 max-w-lg w-full lg:mx-8">
        <div class="relative">
          <input
            type="search"
            placeholder="Search for resources, doctors, treatments…"
            class="w-full py-2.5 px-4 pr-11 rounded-lg border border-gray-300 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent"
          />
          <button class="absolute right-3 top-2.5 text-gray-500 hover:text-blue-600" aria-label="Search">
            <i class="fas fa-search"></i>
          </button>
        </div>
      </div>

      <!-- Desktop CTAs (Language pill sits BEFORE Registration) -->
      <div class="hidden md:flex items-center space-x-3">
        <!-- Language dropdown (desktop) -->
        <li class="mi-lang-wrap list-none relative" role="none">
          <button
            id="mi-lang-btn-desktop"
            class="mi-lang-btn px-3 py-2 rounded-lg flex items-center gap-2 bg-gray-100 hover:bg-gray-200 transition-colors notranslate"
            role="menuitem"
            aria-haspopup="true"
            aria-expanded="false"
          >
            <i class="fa-solid fa-globe text-xs"></i>
            <span>Language</span>
            <i class="fas fa-chevron-down text-[10px]"></i>
          </button>
          <ul
            id="mi-lang-menu-desktop"
            class="mi-lang-menu hidden absolute top-full left-0 mt-1 bg-white shadow-lg rounded-lg py-2 max-h-[320px] overflow-y-auto min-w-[220px] z-50"
            role="menu"
          >
            <li class="px-2 pb-2">
              <input
                id="mi-lang-search-desktop"
                type="search"
                class="w-full px-3 py-2 rounded-md border border-gray-200 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500"
                placeholder="Search language"
              />
            </li>
          </ul>
        </li>

        <a href="<?php echo e(url('/register')); ?>" class="btn btn-register">Registration</a>
        <a href="<?php echo e(url('/login')); ?>" class="btn btn-login">Login</a>
        <a href="<?php echo e(url('/donate')); ?>" class="btn btn-donate">Donate</a>
      </div>
    </div>
  </div>

  <nav class="bg-gradient-to-r from-blue-800 to-green-700 text-white">
    <div class="nav-container">
      <ul id="mi-nav" class="navigation" role="menubar">
        <li role="none"><a role="menuitem" href="<?php echo e(url('/')); ?>" class="hover:bg-blue-700 px-3 py-2 rounded transition-colors">Home</a></li>

        <!-- About -->
        <li class="has-dropdown" role="none">
          <button class="nav-link flex items-center" role="menuitem" aria-haspopup="true" aria-expanded="false">
            About <i class="fas fa-chevron-down ml-1 text-xs"></i>
          </button>
          <div class="dropdown" role="menu">
            <ul>
              <li><a href="#">Our Mission</a></li>
              <li><a href="#">Our Team</a></li>
              <li><a href="#">Annual Reports</a></li>
              <li><a href="#">Financials</a></li>
              <li><a href="#">Partners</a></li>
            </ul>
          </div>
        </li>

        <!-- Advisory Board -->
        <li class="has-dropdown" role="none">
          <button class="nav-link flex items-center" role="menuitem" aria-haspopup="true" aria-expanded="false">
            Advisory Board <i class="fas fa-chevron-down ml-1 text-xs"></i>
          </button>
          <div class="dropdown" role="menu">
            <ul>
              <li><a href="#">Medical Experts</a></li>
              <li><a href="#">Research Advisors</a></li>
              <li><a href="#">Patient Representatives</a></li>
              <li><a href="#">International Advisors</a></li>
            </ul>
          </div>
        </li>

        <!-- Healthcare Professionals -->
        <li class="has-dropdown" role="none">
          <button class="nav-link flex items-center" role="menuitem" aria-haspopup="true" aria-expanded="false">
            Healthcare Professionals <i class="fas fa-chevron-down ml-1 text-xs"></i>
          </button>
          <div class="dropdown" role="menu">
            <ul>
              <li><a href="#">Clinical Guidelines</a></li>
              <li><a href="#">Diagnostic Tools</a></li>
              <li><a href="#">Treatment Protocols</a></li>
              <li><a href="#">Continuing Education</a></li>
            </ul>
          </div>
        </li>

        <!-- Patient Ambassadors -->
        <li class="has-dropdown" role="none">
          <button class="nav-link flex items-center" role="menuitem" aria-haspopup="true" aria-expanded="false">
            Patient Ambassadors <i class="fas fa-chevron-down ml-1 text-xs"></i>
          </button>
          <div class="dropdown" role="menu">
            <ul>
              <li><a href="#">Meet Our Ambassadors</a></li>
              <li><a href="#">Become an Ambassador</a></li>
              <li><a href="#">Ambassador Stories</a></li>
              <li><a href="#">Regional Chapters</a></li>
            </ul>
          </div>
        </li>

        <!-- Activities -->
        <li class="has-dropdown" role="none">
          <button class="nav-link flex items-center" role="menuitem" aria-haspopup="true" aria-expanded="false">
            Activities <i class="fas fa-chevron-down ml-1 text-xs"></i>
          </button>
          <div class="dropdown" role="menu">
            <ul>
              <li><a href="#">Awareness Campaigns</a></li>
              <li><a href="#">Support Groups</a></li>
              <li><a href="#">Workshops</a></li>
              <li><a href="#">Fundraising Events</a></li>
            </ul>
          </div>
        </li>

        <!-- Research -->
        <li class="has-dropdown" role="none">
          <button class="nav-link flex items-center" role="menuitem" aria-haspopup="true" aria-expanded="false">
            Research <i class="fas fa-chevron-down ml-1 text-xs"></i>
          </button>
          <div class="dropdown" role="menu">
            <ul>
              <li><a href="#">Current Studies</a></li>
              <li><a href="#">Research Grants</a></li>
              <li><a href="#">Publications</a></li>
              <li><a href="#">Clinical Trials</a></li>
            </ul>
          </div>
        </li>

        <!-- Videos -->
        <li class="has-dropdown" role="none">
          <button class="nav-link flex items-center" role="menuitem" aria-haspopup="true" aria-expanded="false">
            Videos <i class="fas fa-chevron-down ml-1 text-xs"></i>
          </button>
          <div class="dropdown" role="menu">
            <ul>
              <li><a href="#">Patient Stories</a></li>
              <li><a href="#">Expert Talks</a></li>
              <li><a href="#">Educational Content</a></li>
              <li><a href="#">Event Recordings</a></li>
            </ul>
          </div>
        </li>

        <!-- Mega: More -->
        <li class="has-mega" role="none">
          <button class="nav-link flex items-center" role="menuitem" aria-haspopup="true" aria-expanded="false">
            More <i class="fas fa-chevron-down ml-1 text-xs"></i>
          </button>
          <div class="mega" role="menu">
            <div class="mega-grid">
              <div class="mega-col">
                <h4>Get Involved</h4>
                <ul>
                  <li><a href="#">Volunteer Opportunities</a></li>
                  <li><a href="#">Become a Member</a></li>
                  <li><a href="#">Corporate Partnerships</a></li>
                  <li><a href="#">Advocacy</a></li>
                </ul>
              </div>
              <div class="mega-col">
                <h4>Resources</h4>
                <ul>
                  <li><a href="#">Patient Guides</a></li>
                  <li><a href="#">Caregiver Resources</a></li>
                  <li><a href="#">Treatment Information</a></li>
                  <li><a href="#">FAQ</a></li>
                </ul>
              </div>
              <div class="mega-col">
                <h4>Connect</h4>
                <ul>
                  <li><a href="#">Blog</a></li>
                  <li><a href="#">Newsletter</a></li>
                  <li><a href="#">Social Media</a></li>
                  <li><a href="#">Contact Us</a></li>
                </ul>
              </div>
            </div>
          </div>
        </li>
      </ul>

      <!-- Mobile CTAs + Language -->
      <div id="mi-mobile-buttons" class="mobile-buttons lg:hidden">
        <!-- Mobile language dropdown -->
        <li class="list-none relative w-full" role="none">
          <button
            id="mi-lang-btn-mobile"
            class="w-full px-3 py-2 rounded-lg border border-gray-200 text-[13px] font-semibold bg-white text-gray-800 flex items-center justify-between notranslate"
            role="menuitem"
            aria-haspopup="true"
            aria-expanded="false"
          >
            <span class="inline-flex items-center gap-2">
              <i class="fa-solid fa-globe text-xs"></i>
              <span>Language</span>
            </span>
            <i class="fas fa-chevron-down text-[10px]"></i>
          </button>
        </li>

        <a href="<?php echo e(url('/register')); ?>" class="btn btn-register w-full mt-2">Registration</a>
        <a href="<?php echo e(url('/login')); ?>" class="btn btn-login w-full">Login</a>
        <a href="<?php echo e(url('/donate')); ?>" class="btn btn-donate w-full">Donate</a>
      </div>
    </div>
  </nav>
</header>
<!-- hidden container required by Google Translate widget -->
<div id="mi-google-element" class="hidden"></div>
 
<!-- Mobile Fixed Bottom Navbar (Phone Only) -->
<div class="fixed bottom-0 left-0 w-full z-50 bg-white/95 backdrop-blur-md border-t border-gray-200 shadow-[0_-4px_20px_rgba(0,0,0,0.05)] md:hidden flex items-center justify-around pb-safe pt-2 px-2 h-[65px]">
  <!-- Language -->
  <button id="mi-bottom-lang-btn" class="flex flex-col items-center justify-center gap-1 w-full h-full text-gray-500 hover:text-blue-600 active:scale-95 transition-all">
    <div class="w-8 h-8 rounded-full bg-blue-50 flex items-center justify-center text-blue-600">
       <i class="fa-solid fa-globe text-sm"></i>
    </div>
    <span class="text-[10px] font-bold">Language</span>
  </button>
  
  <!-- Register -->
  <a href="<?php echo e(url('/register')); ?>" class="flex flex-col items-center justify-center gap-1 w-full h-full text-gray-500 hover:text-blue-600 active:scale-95 transition-all">
    <div class="w-8 h-8 rounded-full bg-green-50 flex items-center justify-center text-green-600">
       <i class="fa-solid fa-user-plus text-sm"></i>
    </div>
    <span class="text-[10px] font-bold">Registration</span>
  </a>
  
   <!-- Donate -->
  <a href="<?php echo e(url('/donate')); ?>" class="flex flex-col items-center justify-center gap-1 w-full h-full text-gray-500 hover:text-red-600 active:scale-95 transition-all">
    <div class="w-8 h-8 rounded-full bg-red-50 flex items-center justify-center text-red-600">
       <i class="fa-solid fa-heart text-sm"></i>
    </div>
    <span class="text-[10px] font-bold">Donate</span>
  </a>

   <!-- Appointment -->
  <a href="<?php echo e(url('/appointment')); ?>" class="flex flex-col items-center justify-center gap-1 w-full h-full text-gray-500 hover:text-blue-600 active:scale-95 transition-all">
    <div class="w-8 h-8 rounded-full bg-blue-50 flex items-center justify-center text-blue-600">
       <i class="fa-solid fa-calendar-check text-sm"></i>
    </div>
    <span class="text-[10px] font-bold">Appointment</span>
  </a>
</div>

<!-- Desktop Floating Appointment Button -->
<a href="<?php echo e(url('/appointment')); ?>" class="fixed right-0 top-1/2 -translate-y-1/2 z-40 hidden md:flex flex-col items-center gap-2 bg-gradient-to-b from-sky-400 to-blue-600 text-white py-4 px-1 rounded-l-xl shadow-lg hover:pr-3 transition-all duration-300 group">
  <span class="writing-mode-vertical text-xs font-bold tracking-widest uppercase rotate-180" style="writing-mode: vertical-rl; text-orientation: mixed;">Book Appointment</span>
  <div class="w-8 h-8 bg-white/20 rounded-full flex items-center justify-center group-hover:scale-110 transition-transform">
    <i class="fa-solid fa-calendar-check text-sm"></i>
  </div>
</a>


<script type="module">
(function () {
  // List of supported languages (ISO codes used by Google Translate)
  const LANGUAGES = [
    { code: 'af', label: 'Afrikaans' }, { code: 'sq', label: 'Albanian' }, { code: 'am', label: 'Amharic' },
    { code: 'ar', label: 'Arabic' }, { code: 'hy', label: 'Armenian' }, { code: 'az', label: 'Azerbaijani' },
    { code: 'eu', label: 'Basque' }, { code: 'be', label: 'Belarusian' }, { code: 'bn', label: 'Bengali' },
    { code: 'bs', label: 'Bosnian' }, { code: 'bg', label: 'Bulgarian' }, { code: 'ca', label: 'Catalan' },
    { code: 'ceb', label: 'Cebuano' }, { code: 'ny', label: 'Chichewa' }, { code: 'zh-CN', label: 'Chinese (Simplified)' },
    { code: 'zh-TW', label: 'Chinese (Traditional)' }, { code: 'co', label: 'Corsican' }, { code: 'hr', label: 'Croatian' },
    { code: 'cs', label: 'Czech' }, { code: 'da', label: 'Danish' }, { code: 'nl', label: 'Dutch' },
    { code: 'en', label: 'English' }, { code: 'eo', label: 'Esperanto' }, { code: 'et', label: 'Estonian' },
    { code: 'tl', label: 'Filipino' }, { code: 'fi', label: 'Finnish' }, { code: 'fr', label: 'French' },
    { code: 'fy', label: 'Frisian' }, { code: 'gl', label: 'Galician' }, { code: 'ka', label: 'Georgian' },
    { code: 'de', label: 'German' }, { code: 'el', label: 'Greek' }, { code: 'gu', label: 'Gujarati' },
    { code: 'ht', label: 'Haitian Creole' }, { code: 'ha', label: 'Hausa' }, { code: 'haw', label: 'Hawaiian' },
    { code: 'iw', label: 'Hebrew' }, { code: 'hi', label: 'Hindi' }, { code: 'hmn', label: 'Hmong' },
    { code: 'hu', label: 'Hungarian' }, { code: 'is', label: 'Icelandic' }, { code: 'ig', label: 'Igbo' },
    { code: 'id', label: 'Indonesian' }, { code: 'ga', label: 'Irish' }, { code: 'it', label: 'Italian' },
    { code: 'ja', label: 'Japanese' }, { code: 'jw', label: 'Javanese' }, { code: 'kn', label: 'Kannada' },
    { code: 'kk', label: 'Kazakh' }, { code: 'km', label: 'Khmer' }, { code: 'rw', label: 'Kinyarwanda' },
    { code: 'ko', label: 'Korean' }, { code: 'ku', label: 'Kurdish (Kurmanji)' }, { code: 'ky', label: 'Kyrgyz' },
    { code: 'lo', label: 'Lao' }, { code: 'la', label: 'Latin' }, { code: 'lv', label: 'Latvian' },
    { code: 'lt', label: 'Lithuanian' }, { code: 'lb', label: 'Luxembourgish' }, { code: 'mk', label: 'Macedonian' },
    { code: 'mg', label: 'Malagasy' }, { code: 'ms', label: 'Malay' }, { code: 'ml', label: 'Malayalam' },
    { code: 'mt', label: 'Maltese' }, { code: 'mi', label: 'Maori' }, { code: 'mr', label: 'Marathi' },
    { code: 'mn', label: 'Mongolian' }, { code: 'my', label: 'Myanmar (Burmese)' }, { code: 'ne', label: 'Nepali' },
    { code: 'no', label: 'Norwegian' }, { code: 'or', label: 'Odia (Oriya)' }, { code: 'ps', label: 'Pashto' },
    { code: 'fa', label: 'Persian' }, { code: 'pl', label: 'Polish' }, { code: 'pt', label: 'Portuguese' },
    { code: 'pa', label: 'Punjabi' }, { code: 'ro', label: 'Romanian' }, { code: 'ru', label: 'Russian' },
    { code: 'sm', label: 'Samoan' }, { code: 'gd', label: 'Scots Gaelic' }, { code: 'sr', label: 'Serbian' },
    { code: 'st', label: 'Sesotho' }, { code: 'sn', label: 'Shona' }, { code: 'sd', label: 'Sindhi' },
    { code: 'si', label: 'Sinhala' }, { code: 'sk', label: 'Slovak' }, { code: 'sl', label: 'Slovenian' },
    { code: 'so', label: 'Somali' }, { code: 'es', label: 'Spanish' }, { code: 'su', label: 'Sundanese' },
    { code: 'sw', label: 'Swahili' }, { code: 'sv', label: 'Swedish' }, { code: 'tg', label: 'Tajik' },
    { code: 'ta', label: 'Tamil' }, { code: 'tt', label: 'Tatar' }, { code: 'te', label: 'Telugu' },
    { code: 'th', label: 'Thai' }, { code: 'tr', label: 'Turkish' }, { code: 'tk', label: 'Turkmen' },
    { code: 'uk', label: 'Ukrainian' }, { code: 'ur', label: 'Urdu' }, { code: 'ug', label: 'Uyghur' },
    { code: 'uz', label: 'Uzbek' }, { code: 'vi', label: 'Vietnamese' }, { code: 'cy', label: 'Welsh' },
    { code: 'xh', label: 'Xhosa' }, { code: 'yi', label: 'Yiddish' }, { code: 'yo', label: 'Yoruba' },
    { code: 'zu', label: 'Zulu' }
  ];

  const isMobile = () => window.matchMedia('(max-width: 1024px)').matches;

  const toggleBtn = document.getElementById('mi-toggle');
  const nav = document.getElementById('mi-nav');
  const mobileBtns = document.getElementById('mi-mobile-buttons');
  const langBtnDesktop = document.getElementById('mi-lang-btn-desktop');
  const langMenuDesktop = document.getElementById('mi-lang-menu-desktop');
  const langSearchDesktop = document.getElementById('mi-lang-search-desktop');
  const langBtnMobile = document.getElementById('mi-lang-btn-mobile');
  const langBtnBottom = document.getElementById('mi-bottom-lang-btn'); 
  const googleElId = 'mi-google-element';
  let googleLoaded = false;
  let loadingPromise = null;


  // Cookie Helper Functions
  function setCookie(name, value, days) {
      let expires = "";
      if (days) {
          const date = new Date();
          date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
          expires = "; expires=" + date.toUTCString();
      }
      document.cookie = name + "=" + (value || "") + expires + "; path=/";
  }

  function getCookie(name) {
      const nameEQ = name + "=";
      const ca = document.cookie.split(';');
      for (let i = 0; i < ca.length; i++) {
          let c = ca[i];
          while (c.charAt(0) == ' ') c = c.substring(1, c.length);
          if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length, c.length);
      }
      return null;
  }

  // Build dropdown items only once
  function buildLanguageList(container, onClick) {
    if (!container || container.dataset.built === '1') return;
    LANGUAGES.forEach(({ code, label }) => {
      const item = document.createElement('button');
      item.type = 'button';
      item.className = 'mi-lang-item notranslate block w-full text-left px-4 py-2 hover:bg-gray-100';
      item.dataset.code = code;
      item.textContent = label;
      item.addEventListener('click', onClick);
      const li = document.createElement('li');
      li.role = 'none';
      li.dataset.langItem = '1';
      li.appendChild(item);
      container.appendChild(li);
    });
    container.dataset.built = '1';
  }

  function filterLanguages(container, term) {
    if (!container) return;
    const value = (term || '').toLowerCase();
    container.querySelectorAll('li[data-lang-item]').forEach((li) => {
      const text = li.innerText.toLowerCase();
      li.style.display = text.includes(value) ? '' : 'none';
    });
  }

  // Lazy load Google Translate
  function loadTranslator() {
    if (googleLoaded && window.google?.translate) return Promise.resolve();
    if (loadingPromise) return loadingPromise;
    loadingPromise = new Promise((resolve, reject) => {
      window.googleTranslateElementInit = function () {
        new google.translate.TranslateElement({
          pageLanguage: 'en',
          includedLanguages: LANGUAGES.map((l) => l.code).join(','),
          layout: google.translate.TranslateElement.InlineLayout.HORIZONTAL,
          autoDisplay: false
        }, googleElId);
        googleLoaded = true;
        resolve();
      };
      const script = document.createElement('script');
      script.src = '//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit';
      script.onerror = reject;
      document.head.appendChild(script);
    });
    return loadingPromise;
  }

  // Check for existing language cookie on load
  const currentLang = getCookie('googtrans');
  if (currentLang && currentLang !== '/en/en') {
      loadTranslator();
  }

  function applyLanguage(code) {
    // 1. Update Persistence Cookie
    if (code === 'en') {
        // Reset/Clear for English
        setCookie('googtrans', '/en/en'); 
    } else {
        // Set cookie for chosen language
        setCookie('googtrans', '/en/' + code);
    }

    // 2. Trigger Translation
    loadTranslator().then(() => {
      const combo = document.querySelector(`#${googleElId} select.goog-te-combo`);
      if (!combo) return;
      combo.value = code;
      combo.dispatchEvent(new Event('change'));
    }).catch((err) => console.error('Translator failed to load', err));
  }

  function toggleDesktopMenu(e) {
    e.preventDefault(); e.stopPropagation();
    buildLanguageList(langMenuDesktop, (evt) => {
      evt.preventDefault(); evt.stopPropagation();
      const code = evt.currentTarget.dataset.code;
      langMenuDesktop?.classList.add('hidden');
      applyLanguage(code);
    });
    langSearchDesktop?.focus();
    filterLanguages(langMenuDesktop, langSearchDesktop?.value);
    langMenuDesktop?.classList.toggle('hidden');
    langBtnDesktop?.setAttribute('aria-expanded', String(!langMenuDesktop?.classList.contains('hidden')));
  }

  function openMobileSheet(e) {
    e.preventDefault(); e.stopPropagation();
    if (!isMobile()) return;
    buildLanguageList(sheetList, (evt) => {
      evt.preventDefault(); evt.stopPropagation();
      const code = evt.currentTarget.dataset.code;
      closeSheet();
      applyLanguage(code);
    });
    document.body.appendChild(dim);
    document.body.appendChild(sheet);
    setTimeout(() => sheet.classList.add('mi-lang-sheet-open'), 10);
  }

  // Mobile nav toggle
  toggleBtn?.addEventListener('click', (e) => {
    e.preventDefault(); e.stopPropagation();
    nav?.classList.toggle('active');
    mobileBtns?.classList.toggle('active');
    toggleBtn.setAttribute('aria-expanded', String(!(toggleBtn.getAttribute('aria-expanded') === 'true')));
  });

  // Desktop language dropdown
  langBtnDesktop?.addEventListener('click', toggleDesktopMenu);

  // --- Mobile language bottom sheet (dynamically filled) ---
  const dim = document.createElement('div');
  dim.className = 'mi-sheet-dim';
  dim.addEventListener('click', closeSheet);
  const sheet = document.createElement('div');
  sheet.className = 'mi-lang-sheet';
  sheet.innerHTML = `
    <div class="text-center font-semibold text-gray-700 pb-2 notranslate">Language</div>
    <div class="px-2 pb-2">
      <input id="mi-lang-search-mobile" type="search" class="w-full px-3 py-2 rounded-md border border-gray-200 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Search language" />
    </div>
    <div id="mi-lang-sheet-list" class="max-h-[60vh] overflow-y-auto"></div>
    <button class="w-full mt-2 px-3 py-2 rounded-lg border border-gray-200 text-sm" id="mi-sheet-close">Close</button>
  `;
  const sheetList = sheet.querySelector('#mi-lang-sheet-list');
  const langSearchMobile = sheet.querySelector('#mi-lang-search-mobile');
  sheet.querySelector('#mi-sheet-close')?.addEventListener('click', closeSheet);

  function closeSheet() {
    sheet.classList.remove('mi-lang-sheet-open');
    dim.remove();
    sheet.remove();
  }

  // Connect both triggers for mobile sheet
  langBtnMobile?.addEventListener('click', openMobileSheet);
  langBtnBottom?.addEventListener('click', openMobileSheet);

  // Live search handlers
  langSearchDesktop?.addEventListener('input', (e) => filterLanguages(langMenuDesktop, e.target.value));
  langSearchMobile?.addEventListener('input', (e) => filterLanguages(sheetList, e.target.value));

  // Keep desktop menu open when interacting inside; close only on true outside click
  langMenuDesktop?.addEventListener('click', (e) => e.stopPropagation());
  langSearchDesktop?.addEventListener('click', (e) => e.stopPropagation());
  document.addEventListener('click', (e) => {
    if (!langMenuDesktop || langMenuDesktop.classList.contains('hidden')) return;
    const clickedInsideMenu = langMenuDesktop.contains(e.target);
    const clickedButton = langBtnDesktop?.contains(e.target);
    if (!clickedInsideMenu && !clickedButton) {
      langMenuDesktop.classList.add('hidden');
      langBtnDesktop?.setAttribute('aria-expanded', 'false');
    }
  });

  // Mobile dropdowns for nav items (stop language clicks from triggering these)
  document.querySelectorAll('.navigation .has-dropdown > .nav-link, .navigation .has-mega > .nav-link')
    .forEach(btn => {
      btn.addEventListener('click', (e) => {
        if (!isMobile()) return;
        e.preventDefault(); e.stopPropagation();
        const li = btn.closest('.has-dropdown, .has-mega');
        document.querySelectorAll('.navigation .has-dropdown.open, .navigation .has-mega.open')
          .forEach(el => { if (el !== li) el.classList.remove('open'); });
        li.classList.toggle('open');
      });
    });

  // Reset state across breakpoint changes
  let lastMobile = isMobile();
  window.addEventListener('resize', () => {
    const nowMobile = isMobile();
    if (lastMobile !== nowMobile) {
      nav?.classList.remove('active');
      mobileBtns?.classList.remove('active');
      document.querySelectorAll('.navigation .has-dropdown.open, .navigation .has-mega.open')
        .forEach(el => el.classList.remove('open'));
      toggleBtn?.setAttribute('aria-expanded', 'false');
      closeSheet();
      lastMobile = nowMobile;
    }
  });
})();
</script>
</script><?php /**PATH E:\myositis\website\resources\views/components/updatedheader.blade.php ENDPATH**/ ?>