<?php if(isset($headerUpdates) && $headerUpdates->isNotEmpty()): ?>
    
    <div class="relative z-40 bg-gradient-to-r from-slate-50 via-white to-blue-50/30 border-b border-slate-200 shadow-[0_1px_2px_rgba(0,0,0,0.02)] backdrop-blur-sm">
        <div class="container mx-auto px-4">
            <div class="flex items-center py-1.5 overflow-hidden">
                
                <div class="flex items-center gap-1.5 shrink-0 mr-3 pl-1 pr-3 py-0.5 rounded-full bg-blue-50 border border-blue-100/50 shadow-sm relative group cursor-default">
                    <span class="absolute inset-0 rounded-full bg-blue-400 opacity-0 group-hover:opacity-10 transition-opacity duration-500"></span>
                    <i class="fa-solid fa-bolt text-amber-500 text-[10px] animate-pulse"></i>
                    <span class="text-[10px] font-black uppercase tracking-widest text-blue-800">Highlights</span>
                </div>

                
                <div class="h-3 w-px bg-slate-200 shrink-0 mr-3 hidden sm:block"></div>
                
                
                <div class="flex-1 overflow-x-auto no-scrollbar mask-gradient-right flex items-center">
                    <div class="flex items-center gap-4 whitespace-nowrap">
                        <?php $__currentLoopData = $headerUpdates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $update): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('updates.show', $update->slug)); ?>" class="group/item flex items-center gap-1.5 text-[11px] sm:text-xs font-semibold text-slate-600 hover:text-blue-700 transition-all duration-300">
                                <span class="group-hover/item:underline decoration-blue-300 decoration-2 underline-offset-2"><?php echo e($update->title); ?></span>
                                <i class="fa-solid fa-chevron-right text-[8px] opacity-0 -translate-x-1 group-hover/item:opacity-100 group-hover/item:translate-x-0 transition-all text-blue-400"></i>
                            </a>

                            <?php if(!$loop->last): ?>
                                <span class="w-1 h-1 rounded-full bg-slate-300 hidden sm:block"></span>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH E:\myositis\website\resources\views/sections/pinned-updates.blade.php ENDPATH**/ ?>