<?php $__env->startSection('title', 'Login – Myositis India'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-[70vh] flex items-center justify-center">
    <div class="w-full max-w-md bg-white/90 shadow-lg rounded-2xl p-8 border border-slate-200">
        <h1 class="text-2xl font-extrabold text-slate-900 mb-2 text-center">
            Welcome back
        </h1>
        <p class="text-sm text-slate-600 mb-6 text-center">
            Login to access your Myositis India dashboard.
        </p>

        <?php if(session('error')): ?>
            <div class="mb-4 text-sm text-red-600 bg-red-50 border border-red-200 rounded-lg px-3 py-2">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="mb-4 text-sm text-red-600 bg-red-50 border border-red-200 rounded-lg px-3 py-2">
                <?php echo e($errors->first()); ?>

            </div>
        <?php endif; ?>

        <form method="POST" action="<?php echo e(route('login.post')); ?>" class="space-y-4">
            <?php echo csrf_field(); ?>

            <div>
                <label class="block text-sm font-semibold text-slate-700 mb-1">Email</label>
                <input type="email" name="email" value="<?php echo e(old('email')); ?>"
                       required autofocus
                       class="w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-sky-500 focus:border-sky-500">
            </div>

            <div>
                <label class="block text-sm font-semibold text-slate-700 mb-1">Password</label>
                <input type="password" name="password" required
                       class="w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-sky-500 focus:border-sky-500">
            </div>

            <div class="flex items-center justify-between text-sm">
                <label class="flex items-center gap-2">
                    <input type="checkbox" name="remember" class="rounded border-slate-300">
                    <span>Remember me</span>
                </label>
                
                <span class="text-sky-700 font-medium text-xs opacity-60">Forgot password?</span>
            </div>

            <button type="submit"
                    class="w-full mt-2 font-semibold text-sm text-white rounded-lg py-2.5
                           shadow-md hover:shadow-lg transition
                           bg-gradient-to-r from-sky-600 to-emerald-500">
                Login
            </button>
        </form>

        <p class="mt-4 text-xs text-slate-600 text-center">
            New here?
            <a href="" class="text-sky-700 font-semibold hover:underline">
                Create an account
            </a>
        </p>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\myositis\website\resources\views/auth/login.blade.php ENDPATH**/ ?>