<?php $__env->startSection('title', 'Latest Updates'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-5xl mx-auto space-y-6">
    <section class="flex items-center justify-between">
        <div>
            <h1 class="text-xl font-semibold text-softTextMain">Latest Updates</h1>
            <p class="text-xs text-softTextMute">
                Small announcements that appear on your homepage in the <strong>Latest Updates</strong> strip.
            </p>
        </div>
        <a href="<?php echo e(route('admin.updates.create')); ?>"
           class="px-3 py-2 rounded-xl bg-softSky text-white text-xs font-medium hover:bg-softTeal transition">
            + Add Update
        </a>
    </section>

    <?php if(session('success')): ?>
        <div class="rounded-xl border border-emerald-200 bg-emerald-50 px-3 py-2 text-xs text-emerald-700">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <section class="rounded-2xl border border-softBorder bg-softCard shadow-sm overflow-hidden text-xs">
        <div class="overflow-x-auto">
            <table class="min-w-full">
                <thead class="bg-softBg border-b border-softBorder text-[11px] uppercase tracking-[0.15em] text-softTextMute">
                    <tr>
                        <th class="px-4 py-3 text-left">Title</th>
                        <th class="px-4 py-3 text-left">Category</th>
                        <th class="px-4 py-3 text-left">Published</th>
                        <th class="px-4 py-3 text-left">Pinned</th>
                        <th class="px-4 py-3 text-right">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-softBorder">
                    <?php $__empty_1 = true; $__currentLoopData = $updates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $update): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-slate-50/80">
                            <td class="px-4 py-3 text-softTextMain">
                                <?php echo e($update->title); ?>

                                <?php if($update->excerpt): ?>
                                    <div class="text-[11px] text-softTextMute mt-0.5 line-clamp-1">
                                        <?php echo e($update->excerpt); ?>

                                    </div>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3 text-softTextMute">
                                <?php echo e($update->category ?? '—'); ?>

                            </td>
                            <td class="px-4 py-3">
                                <?php if($update->is_published): ?>
                                    <span class="inline-flex px-2 py-0.5 rounded-full bg-emerald-50 border border-emerald-200 text-[10px] text-emerald-700">
                                        <?php echo e(optional($update->published_at)->format('d M Y') ?? 'Published'); ?>

                                    </span>
                                <?php else: ?>
                                    <span class="inline-flex px-2 py-0.5 rounded-full bg-slate-100 border border-softBorder text-[10px] text-softTextMute">
                                        Draft
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3">
                                <?php if($update->is_pinned): ?>
                                    <span class="inline-flex px-2 py-0.5 rounded-full bg-amber-50 border border-amber-200 text-[10px] text-amber-700">
                                        Pinned
                                    </span>
                                <?php else: ?>
                                    <span class="text-[10px] text-softTextMute">—</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3 text-right">
                                <a href="<?php echo e(route('admin.updates.edit', $update)); ?>"
                                   class="text-[11px] text-softSky hover:underline mr-2">
                                    Edit
                                </a>
                                <form action="<?php echo e(route('admin.updates.destroy', $update)); ?>"
                                      method="POST"
                                      class="inline-block"
                                      onsubmit="return confirm('Delete this update?');">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit"
                                            class="text-[11px] text-rose-500 hover:underline">
                                        Delete
                                    </button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="px-4 py-6 text-center text-softTextMute text-[11px]">
                                No updates yet. Click “Add Update” to create your first announcement.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="px-4 py-3 border-t border-softBorder bg-white/80">
            <?php echo e($updates->links()); ?>

        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\myositis\website\resources\views/admin/updates/index.blade.php ENDPATH**/ ?>