<!-- Welcome Section started-->
<div class="bg-white rounded-lg shadow-md p-6">
    <h2 class="text-2xl font-bold text-blue-800 mb-4">Welcome to Myositis India</h2>
    <p class="text-gray-600 mb-4">
        Welcome to Myositis India, a unit of Madalasa Foundation, a non-profit organization
        dedicated to improving the lives of people affected by myositis in India. If you're looking to learn more about
        Myositis India, our mission is to raise awareness, provide support, and promote research for myositis—a rare and
        complex autoimmune disease that causes inflammation and weakness in the muscles. We provide a platform for
        patients, caregivers, and healthcare professionals to connect, share their experiences, and learn from each
        other. As a dedicated nonprofit for myositis, our website offers a wealth of resources, including educational
        materials, support groups, and information on clinical trials and treatment options.
        <a href="#" class="inline-block text-green-600 font-medium hover:underline">Learn More!</a>
    </p>
 

    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mt-8">
        <div class="bg-blue-50 p-6 rounded-lg border-l-4 border-blue-600">
            <h3 class="text-xl font-semibold text-blue-800 mb-2">Patient Helpline</h3>
            <p class="text-gray-600">Get immediate support and guidance from our dedicated helpline team.</p>
            <a href="#" class="inline-block mt-4 text-blue-600 font-medium hover:underline">Learn more</a>
        </div>

        <div class="bg-green-50 p-6 rounded-lg border-l-4 border-green-600">
            <h3 class="text-xl font-semibold text-green-800 mb-2">Expert Network</h3>
            <p class="text-gray-600">Connect with specialists who understand Myositis and its challenges.</p>
            <a href="#" class="inline-block mt-4 text-green-600 font-medium hover:underline">Find experts</a>
        </div>

        <div class="bg-blue-50 p-6 rounded-lg border-l-4 border-blue-600">
            <h3 class="text-xl font-semibold text-blue-800 mb-2">Clinical Research</h3>
            <p class="text-gray-600">Stay informed about the latest research and clinical trials.</p>
            <a href="#" class="inline-block mt-4 text-blue-600 font-medium hover:underline">Explore research</a>
        </div>
    </div>
</div>

<?php /**PATH E:\myositis\website\resources\views/sections/welcome.blade.php ENDPATH**/ ?>