<?php $__env->startSection('title', 'Healthcare Professional Registration – Myositis India'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen flex items-start justify-center px-4 py-10 bg-gradient-to-br from-sky-50 via-white to-emerald-50">
    <div class="w-full max-w-3xl space-y-6">

        
        <?php if(session('success')): ?>
            <div class="rounded-xl bg-emerald-50 border border-emerald-200 px-4 py-3 text-sm text-emerald-800 shadow-sm">
                <div class="flex items-start gap-3">
                    <div class="mt-0.5 flex h-7 w-7 items-center justify-center rounded-full bg-emerald-100 text-emerald-700 text-base">
                        ✓
                    </div>
                    <div>
                        <div class="font-semibold">Registration successful</div>
                        <p class="mt-0.5"><?php echo e(session('success')); ?></p>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        
        <?php if($errors->any()): ?>
            <div class="rounded-xl bg-red-50 border border-red-200 px-4 py-3 text-sm text-red-800 shadow-sm">
                <div class="flex items-start gap-3">
                    <div class="mt-0.5 flex h-7 w-7 items-center justify-center rounded-full bg-red-100 text-red-600 text-base">
                        ⚠
                    </div>
                    <div>
                        <div class="font-semibold">Please check the highlighted fields</div>
                        <ul class="mt-1 list-disc list-inside space-y-0.5">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="text-red-700"><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        
        <div class="bg-slate-50 rounded-2xl shadow-xl border border-slate-200/80 overflow-hidden">
            
            <div class="h-2 w-full bg-gradient-to-r from-[#0096D6] via-[#00a9e8] to-[#6DBE45]"></div>

            
            <div class="px-6 pt-6 pb-4 border-b border-slate-200/70 bg-white/80">
                <h1 class="text-2xl md:text-3xl font-semibold text-slate-900">
                    Healthcare Professional Registration
                </h1>
                <p class="mt-2 text-sm md:text-[15px] text-slate-600 max-w-2xl">
                    Join our medical community to collaborate, share expertise, and enhance myositis care worldwide.
                    Fields marked with <span class="text-red-500">*</span> are required.
                </p>
            </div>

            
            <form id="registrationForm"
                  action="<?php echo e(route('register.doctor.submit')); ?>"
                  method="POST"
                  class="px-6 pb-6 pt-4 space-y-6">
                <?php echo csrf_field(); ?>

                
                <div class="pt-2 pb-2 border-b border-slate-200/70">
                    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                        
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                First Name <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="fname" value="<?php echo e(old('fname')); ?>"
                                   class="w-full rounded-lg border <?php $__errorArgs = ['fname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 bg-red-50 <?php else: ?> border-slate-300 focus:border-[#0096D6] <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="First name">
                            <?php $__errorArgs = ['fname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Last Name <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="lname" value="<?php echo e(old('lname')); ?>"
                                   class="w-full rounded-lg border <?php $__errorArgs = ['lname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 bg-red-50 <?php else: ?> border-slate-300 focus:border-[#0096D6] <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="Last name">
                            <?php $__errorArgs = ['lname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Mobile <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="phone" value="<?php echo e(old('phone')); ?>"
                                   class="w-full rounded-lg border <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 bg-red-50 <?php else: ?> border-slate-300 focus:border-[#0096D6] <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="Your mobile">
                            <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Email <span class="text-red-500">*</span>
                            </label>
                            <input type="email" name="email" value="<?php echo e(old('email')); ?>"
                                   class="w-full rounded-lg border <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 bg-red-50 <?php else: ?> border-slate-300 focus:border-[#0096D6] <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="Your email">
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                
                <div class="pt-2 pb-2 border-b border-slate-200/70">
                    <div class="grid grid-cols-1 gap-4 md:grid-cols-3">
                        
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Country <span class="text-red-500">*</span>
                            </label>
                            <select name="country"
                                    class="w-full rounded-lg border <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 bg-red-50 <?php else: ?> border-slate-300 focus:border-[#0096D6] <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white">
                                <option value="">Select Country</option>
                                <option value="India" <?php echo e(old('country')=='India' ? 'selected' : ''); ?>>India</option>
                                <option value="United States" <?php echo e(old('country')=='United States' ? 'selected' : ''); ?>>United States</option>
                                <option value="United Kingdom" <?php echo e(old('country')=='United Kingdom' ? 'selected' : ''); ?>>United Kingdom</option>
                            </select>
                            <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                State <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="state" value="<?php echo e(old('state')); ?>"
                                   class="w-full rounded-lg border <?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 bg-red-50 <?php else: ?> border-slate-300 focus:border-[#0096D6] <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="State">
                            <?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                City <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="city" value="<?php echo e(old('city')); ?>"
                                   class="w-full rounded-lg border <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 bg-red-50 <?php else: ?> border-slate-300 focus:border-[#0096D6] <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="City">
                            <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                
                <div class="pt-2 pb-2 border-b border-slate-200/70">
                    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                        
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Gender <span class="text-red-500">*</span>
                            </label>
                            <select name="gender"
                                    class="w-full rounded-lg border <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 bg-red-50 <?php else: ?> border-slate-300 focus:border-[#0096D6] <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white">
                                <option value="">Select</option>
                                <option value="male" <?php echo e(old('gender')=='male' ? 'selected' : ''); ?>>Male</option>
                                <option value="female" <?php echo e(old('gender')=='female' ? 'selected' : ''); ?>>Female</option>
                                <option value="other" <?php echo e(old('gender')=='other' ? 'selected' : ''); ?>>Other</option>
                            </select>
                            <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Age <span class="text-red-500">*</span>
                            </label>
                            <input type="number" name="age" value="<?php echo e(old('age')); ?>" min="20" max="100"
                                   class="w-full rounded-lg border <?php $__errorArgs = ['age'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 bg-red-50 <?php else: ?> border-slate-300 focus:border-[#0096D6] <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white [appearance:textfield] [&::-webkit-outer-spin-button]:appearance-none [&::-webkit-inner-spin-button]:appearance-none"
                                   placeholder="Your age">
                            <?php $__errorArgs = ['age'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    
                    <div class="mt-4">
                        <label class="block text-xs font-medium text-slate-800 mb-1.5">
                            Speciality / Area <span class="text-red-500">*</span>
                        </label>
                        <select name="doctorSpeciality"
                                class="w-full rounded-lg border <?php $__errorArgs = ['doctorSpeciality'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 bg-red-50 <?php else: ?> border-slate-300 focus:border-[#0096D6] <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white">
                            <option value="">Speciality/Area</option>
                            <option value="Rheumatologist"      <?php echo e(old('doctorSpeciality')=='Rheumatologist' ? 'selected' : ''); ?>>Rheumatologist</option>
                            <option value="Neurologist"         <?php echo e(old('doctorSpeciality')=='Neurologist' ? 'selected' : ''); ?>>Neurologist</option>
                            <option value="Immunologist"        <?php echo e(old('doctorSpeciality')=='Immunologist' ? 'selected' : ''); ?>>Immunologist</option>
                            <option value="General Physician"   <?php echo e(old('doctorSpeciality')=='General Physician' ? 'selected' : ''); ?>>General Physician</option>
                            <option value="Gastroenterologist"  <?php echo e(old('doctorSpeciality')=='Gastroenterologist' ? 'selected' : ''); ?>>Gastroenterologist</option>
                            <option value="Cardiologist"        <?php echo e(old('doctorSpeciality')=='Cardiologist' ? 'selected' : ''); ?>>Cardiologist</option>
                            <option value="Nephrologist"        <?php echo e(old('doctorSpeciality')=='Nephrologist' ? 'selected' : ''); ?>>Nephrologist</option>
                            <option value="Gynecologist"        <?php echo e(old('doctorSpeciality')=='Gynecologist' ? 'selected' : ''); ?>>Gynecologist</option>
                            <option value="Orthopedist"         <?php echo e(old('doctorSpeciality')=='Orthopedist' ? 'selected' : ''); ?>>Orthopedist</option>
                            <option value="Ophthalmologist"     <?php echo e(old('doctorSpeciality')=='Ophthalmologist' ? 'selected' : ''); ?>>Ophthalmologist</option>
                            <option value="Surgeon"             <?php echo e(old('doctorSpeciality')=='Surgeon' ? 'selected' : ''); ?>>Surgeon</option>
                            <option value="Dietician"           <?php echo e(old('doctorSpeciality')=='Dietician' ? 'selected' : ''); ?>>Dietician</option>
                            <option value="Physiotherapist"     <?php echo e(old('doctorSpeciality')=='Physiotherapist' ? 'selected' : ''); ?>>Physiotherapist</option>
                            <option value="Pharmacist"          <?php echo e(old('doctorSpeciality')=='Pharmacist' ? 'selected' : ''); ?>>Pharmacist</option>
                            <option value="Yoga practitioner"   <?php echo e(old('doctorSpeciality')=='Yoga practitioner' ? 'selected' : ''); ?>>Yoga practitioner</option>
                            <option value="Other"               <?php echo e(old('doctorSpeciality')=='Other' ? 'selected' : ''); ?>>Other</option>
                        </select>
                        <?php $__errorArgs = ['doctorSpeciality'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    
                    <div class="mt-4">
                        <label class="block text-xs font-medium text-slate-800 mb-1.5">
                            How many myositis patients do you typically see in a year? <span class="text-red-500">*</span>
                        </label>
                        <select name="myositis_count"
                                class="w-full rounded-lg border <?php $__errorArgs = ['myositis_count'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 bg-red-50 <?php else: ?> border-slate-300 focus:border-[#0096D6] <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white">
                            <option value="">Select range</option>
                            <option value="1-10"   <?php echo e(old('myositis_count')=='1-10' ? 'selected' : ''); ?>>1-10 patients</option>
                            <option value="11-50"  <?php echo e(old('myositis_count')=='11-50' ? 'selected' : ''); ?>>11-50 patients</option>
                            <option value="51-100" <?php echo e(old('myositis_count')=='51-100' ? 'selected' : ''); ?>>51-100 patients</option>
                            <option value="100+"   <?php echo e(old('myositis_count')=='100+' ? 'selected' : ''); ?>>100+ patients</option>
                        </select>
                        <?php $__errorArgs = ['myositis_count'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                
                <div class="pt-2 pb-2 border-b border-slate-200/70">
                    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                        
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Password <span class="text-red-500">*</span>
                            </label>
                            <div class="relative">
                                <input id="password" type="password" name="password"
                                       class="w-full rounded-lg border <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 bg-red-50 <?php else: ?> border-slate-300 focus:border-[#0096D6] <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> px-3.5 py-2.5 text-sm pr-16 focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                       placeholder="Create password" required>
                                <button type="button"
                                        onclick="togglePassword('password','password-toggle-label')"
                                        class="absolute inset-y-0 right-2 flex items-center text-[11px] font-medium text-slate-500 hover:text-slate-700">
                                    <span id="password-toggle-label"
                                          class="rounded-md px-2 py-1 bg-slate-100 hover:bg-slate-200">
                                        Show
                                    </span>
                                </button>
                            </div>
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Confirm Password <span class="text-red-500">*</span>
                            </label>
                            <div class="relative">
                                <input id="password_confirmation" type="password" name="password_confirmation"
                                       class="w-full rounded-lg border border-slate-300 focus:border-[#0096D6] px-3.5 py-2.5 text-sm pr-16 focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                       placeholder="Confirm password" required>
                                <button type="button"
                                        onclick="togglePassword('password_confirmation','password-confirm-toggle-label')"
                                        class="absolute inset-y-0 right-2 flex items-center text-[11px] font-medium text-slate-500 hover:text-slate-700">
                                    <span id="password-confirm-toggle-label"
                                          class="rounded-md px-2 py-1 bg-slate-100 hover:bg-slate-200">
                                        Show
                                    </span>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="pt-2 pb-2 border-b border-slate-200/70">
                    <h2 class="text-sm font-semibold text-slate-900 mb-1.5">
                        Tell us about your professional background
                    </h2>
                    <p class="text-xs text-slate-500 mb-4">
                        Share your experience, interests, or how you'd like to contribute to our community. 
                        <span class="text-red-500">*</span>
                    </p>

                    <textarea name="message" rows="4"
                              class="w-full rounded-lg border <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 bg-red-50 <?php else: ?> border-slate-300 focus:border-[#0096D6] <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white resize-y"
                              placeholder="Example: years in practice, myositis experience, research interests, etc."><?php echo e(old('message')); ?></textarea>
                    <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                
                <div class="pt-2 pb-1 space-y-4">
                    
                    <div>
                        <h2 class="text-sm font-semibold text-slate-900 mb-1.5">
                            Security check
                        </h2>
                        <p class="text-xs text-slate-500 mb-3">
                            This small question helps us protect the form from spam. <span class="text-red-500">*</span>
                        </p>
                        <div class="flex flex-col sm:flex-row gap-3 sm:items-center">
                            <span class="inline-flex items-center justify-center rounded-lg bg-[#E6F5FB] px-4 py-2.5 text-sm font-semibold text-[#0096D6] border border-[#BFE4F6] min-w-[130px]">
                                <?php echo e($captchaQuestion); ?>

                            </span>
                            <input type="number" name="captcha_answer"
                                   class="flex-1 rounded-lg border <?php $__errorArgs = ['captcha_answer'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 bg-red-50 <?php else: ?> border-slate-300 focus:border-[#0096D6] <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white [appearance:textfield] [&::-webkit-outer-spin-button]:appearance-none [&::-webkit-inner-spin-button]:appearance-none"
                                   placeholder="Your answer" min="0">
                        </div>
                        <?php $__errorArgs = ['captcha_answer'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    
                    <div class="rounded-xl bg-slate-50 border border-slate-200 px-3.5 py-3">
                        <label class="flex items-start gap-3">
                            <input type="checkbox" name="terms" value="1" <?php echo e(old('terms') ? 'checked' : ''); ?>

                                   class="mt-1 h-4 w-4 rounded border-slate-300 text-[#0096D6] focus:ring-[#0096D6]">
                            <span class="text-xs text-slate-700 leading-relaxed">
                                I accept the
                                <a href="https://myositisindia.org/termcondition" target="_blank"
                                   class="text-[#0096D6] hover:text-[#007bb0] font-medium underline">
                                    terms and conditions
                                </a>
                                of Myositis India. <span class="text-red-500">*</span>
                            </span>
                        </label>
                        <?php $__errorArgs = ['terms'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                
                <div class="mt-4 pt-4 border-t border-slate-200 flex flex-col sm:flex-row items-stretch sm:items-center justify-between gap-3">
                    <a href="<?php echo e(route('register.role')); ?>"
                       class="inline-flex items-center justify-center gap-1.5 rounded-full border border-slate-300 bg-white px-4 py-2.5 text-xs font-medium text-slate-700 hover:bg-slate-50">
                        <span class="text-base leading-none">←</span>
                        <span>Back to choose role</span>
                    </a>

                    <button type="submit" id="submitBtn"
                            class="inline-flex items-center justify-center gap-2 rounded-full bg-[#0096D6] hover:bg-[#007bb0] px-6 py-2.5 text-xs font-semibold text-white shadow-md hover:shadow-lg focus:outline-none focus:ring-2 focus:ring-[#0096D6] focus:ring-offset-1">
                        <span id="submitLabel">Complete professional registration</span>
                        <svg id="submitSpinner" class="hidden h-4 w-4 animate-spin" viewBox="0 0 24 24" fill="none">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor"
                                  d="M4 12a8 8 0 018-8V0C5.37 0 0 5.37 0 12h4z"></path>
                        </svg>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>


<?php echo $__env->make('components.registration-processing-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Simple password show/hide
    function togglePassword(inputId, labelId) {
        const input = document.getElementById(inputId);
        const label = document.getElementById(labelId);

        if (!input) return;

        if (input.type === 'password') {
            input.type = 'text';
            if (label) label.textContent = 'Hide';
        } else {
            input.type = 'password';
            if (label) label.textContent = 'Show';
        }
    }

    // Form submission handling
    document.getElementById('registrationForm')?.addEventListener('submit', function () {
        const submitBtn = document.getElementById('submitBtn');
        const spinner   = document.getElementById('submitSpinner');
        const label     = document.getElementById('submitLabel');
        const modal     = document.getElementById('processingModal');

        if (submitBtn && spinner && label) {
            submitBtn.disabled = true;
            submitBtn.classList.add('opacity-80', 'cursor-not-allowed');
            spinner.classList.remove('hidden');
            label.textContent = 'Processing…';
        }

        if (modal) {
            modal.classList.remove('hidden');
        }
    });

    // Prevent negative / invalid age values (20–100)
    const ageInput = document.querySelector('input[name="age"]');
    if (ageInput) {
        ageInput.addEventListener('input', function () {
            if (this.value < 20)  this.value = 20;
            if (this.value > 100) this.value = 100;
        });

        ageInput.addEventListener('keydown', function (e) {
            if (['e', 'E', '-', '+'].includes(e.key)) {
                e.preventDefault();
            }
        });
    }
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\myositis\website\resources\views/auth/register-doctor.blade.php ENDPATH**/ ?>