<?php

namespace Tests\Feature;

use Tests\TestCase;
use Illuminate\Foundation\Testing\RefreshDatabase;
use App\Models\User;
use App\Models\Todo;

class TodoFeatureTest extends TestCase
{
    use RefreshDatabase;

    public function test_support_can_create_todo_and_assign_volunteer()
    {
        $support = User::factory()->create(['role' => User::ROLE_SUPPORT, 'is_approved' => true, 'is_active' => true]);
        $volunteer = User::factory()->create(['role' => User::ROLE_VOLUNTEER, 'is_approved' => true, 'is_active' => true]);

        $this->actingAs($support)
            ->post(route('support.todos.store'), [
                'title' => 'Test task',
                'priority' => 'high',
                'assignees' => [$volunteer->id],
            ])
            ->assertRedirect(route('support.todos.index'));

        $this->assertDatabaseHas('todos', ['title' => 'Test task']);
        $todo = Todo::where('title', 'Test task')->first();
        $this->assertDatabaseHas('todo_volunteer', ['todo_id' => $todo->id, 'volunteer_id' => $volunteer->id]);
    }

    public function test_volunteer_sees_assigned_todo()
    {
        $support = User::factory()->create(['role' => User::ROLE_SUPPORT, 'is_approved' => true, 'is_active' => true]);
        $volunteer = User::factory()->create(['role' => User::ROLE_VOLUNTEER, 'is_approved' => true, 'is_active' => true]);

        $todo = Todo::create([
            'title' => 'Assigned task',
            'priority' => 'medium',
            'created_by' => $support->id,
        ]);

        $todo->volunteers()->attach($volunteer->id, ['assigned_by' => $support->id, 'assigned_at' => now()]);

        $this->actingAs($volunteer)
            ->get(route('volunteer.todos.index'))
            ->assertSee('Assigned task');
    }
}
