<?php

namespace Tests\Feature;

use Tests\TestCase;
use Illuminate\Foundation\Testing\RefreshDatabase;
use App\Models\User;
use App\Models\Todo;
use App\Models\TodoUpdate;

class VolunteerMarkTodoCompletedTest extends TestCase
{
    use RefreshDatabase;

    public function test_volunteer_can_mark_assigned_todo_completed_and_notify_support()
    {
        $support = User::factory()->create(['role' => User::ROLE_SUPPORT, 'is_approved' => true, 'is_active' => true]);
        $volunteer = User::factory()->create(['role' => User::ROLE_VOLUNTEER, 'is_approved' => true, 'is_active' => true]);

        $todo = Todo::create([
            'title' => 'Complete me',
            'priority' => 'medium',
            'created_by' => $support->id,
        ]);

        $todo->volunteers()->attach($volunteer->id, ['assigned_by' => $support->id, 'assigned_at' => now()]);

        $this->actingAs($volunteer)
            ->post(route('volunteer.todos.complete', $todo))
            ->assertRedirect();

        $this->assertDatabaseHas('todos', ['id' => $todo->id, 'status' => 'completed', 'progress' => 100]);
        $this->assertDatabaseHas('todo_updates', ['todo_id' => $todo->id, 'user_id' => $volunteer->id, 'type' => 'status']);

        // Support should have a notification
        $this->assertDatabaseHas('notifications', ['notifiable_id' => $support->id, 'notifiable_type' => 'App\\Models\\User']);
    }
}
