<?php

namespace App\Console\Commands;

use App\Models\Compliances\Adt1Compliance;
use App\Models\Core\Company;
use App\Models\Core\ComplianceType;
use App\Models\Core\FinancialSession;
use Illuminate\Console\Command;

class TestLogic extends Command
{
    protected $signature = 'test:logic';
    protected $description = 'Verify ADT-1 Logic';

    public function handle()
    {
        $session = FinancialSession::where('name', '2024-25')->firstOrFail();
        $company = Company::firstOrFail();
        $type = ComplianceType::where('code', 'ADT1')->firstOrFail();

        // 1. Verify Company is linked to Session
        if (!$company->financialSessions->contains($session->id)) {
            $this->error('Linkage Error: Company not linked to Session!');
            return 1;
        }

        // 2. Create ADT-1 Record
        $record = Adt1Compliance::create([
            'company_id' => $company->id,
            'financial_session_id' => $session->id,
            'compliance_type_id' => $type->id,
            'status' => 'Filed',
            'date_of_filing' => '2024-05-15',
            'srn' => 'G12345678',
            'name_of_signing_auditor' => 'CA Praveen',
            'agm_held' => true,
        ]);

        $this->info("Success! Created ADT-1 Record #{$record->id}");
        $this->info("  - Company: {$record->company->name}");
        $this->info("  - Session: {$record->financialSession->name}");
        $this->info("  - Status: {$record->status}");
        $this->info("  - Auditor: {$record->name_of_signing_auditor}");

        return 0;
    }
}
