<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Compliances\Adt1Compliance;
use App\Models\Core\Company;
use App\Models\Core\FinancialSession;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        $complianceGroups = \App\Models\Core\ComplianceGroup::where('is_active', true)
            ->with(['complianceTypes']) // Eager load types
            ->orderBy('name')
            ->get();

        // Calculate Pending Counts for visualization
        $activeSession = FinancialSession::where('is_active', true)->first();

        if ($activeSession) {
            foreach ($complianceGroups as $group) {
                // Initialize stats array
                $group->module_stats = [];

                if ($group->code === 'ROC') {
                    $totalCompanies = $activeSession->companies()->count();
                    $stats = [];

                    foreach ($group->complianceTypes as $type) {
                        $typeFiledCount = 0;

                        if ($type->code === 'ADT1') {
                            $typeFiledCount = Adt1Compliance::where('financial_session_id', $activeSession->id)
                                ->where('status', 'Filed')
                                ->whereHas('company', function ($q) use ($activeSession) {
                                    $q->whereHas('financialSessions', function ($sub) use ($activeSession) {
                                        $sub->where('financial_sessions.id', $activeSession->id);
                                    });
                                })
                                ->count();
                        }

                        $stats[] = [
                            'name' => $type->code,
                            'pending' => $totalCompanies - $typeFiledCount,
                        ];
                    }
                    $group->module_stats = $stats;
                }
            }
        }

        return view('admin.dashboard', compact('complianceGroups'));
    }
}
