<?php

namespace App\Models\Compliances;

use App\Models\Core\Company;
use App\Models\Core\ComplianceType;
use App\Models\Core\FinancialSession;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Adt1Compliance extends Model
{
    use HasFactory;

    protected $table = 'adt1_compliances';

    protected $fillable = [
        'company_id',
        'financial_session_id',
        'compliance_type_id',
        'status',
        'date_of_filing',
        'srn',
        'date_of_appointment',
        'agm_held',        // Now date
        'from_year',       // Now date
        'to_year',         // Now date
        'due_date',        // New
        'no_of_years',     // New
        'name_of_signing_auditor',
        'name_of_auditor_firm',
        'checked_by',
    ];

    protected $casts = [
        'date_of_filing' => 'date',
        'date_of_appointment' => 'date',
        'agm_held' => 'date',
        'from_year' => 'date',
        'to_year' => 'date',
        'due_date' => 'date',
    ];

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }

    public function financialSession(): BelongsTo
    {
        return $this->belongsTo(FinancialSession::class);
    }

    public function complianceType(): BelongsTo
    {
        return $this->belongsTo(ComplianceType::class);
    }
}
