<?php

namespace App\Models\Core;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Company extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'cin',
        'pan',
        'tan',
        'registered_office_address',
        'incorporation_date',
        'gstin',
        'email',
    ];

    protected $casts = [
        'incorporation_date' => 'date',
    ];

    /**
     * The financial sessions that the company belongs to.
     */
    public function financialSessions(): BelongsToMany
    {
        return $this->belongsToMany(FinancialSession::class, 'company_financial_session')
            ->withPivot('status')
            ->withTimestamps();
    }

    public function adt1Compliances()
    {
        return $this->hasMany(\App\Models\Compliances\Adt1Compliance::class);
    }
}
