<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('compliance_types', function (Blueprint $table) {
            $table->id();
            $table->foreignId('compliance_group_id')->constrained()->cascadeOnDelete();
            $table->string('name'); // e.g., "ADT-1"
            $table->string('code')->unique(); // e.g., "ADT1"
            $table->string('table_name'); // e.g., "adt1_compliances"
            $table->integer('priority')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('compliance_types');
    }
};
