<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('adt1_compliances', function (Blueprint $table) {
            $table->id();

            // Standard Compliance Columns
            $table->foreignId('company_id')->constrained()->cascadeOnDelete();
            $table->foreignId('financial_session_id')->constrained()->cascadeOnDelete();
            $table->foreignId('compliance_type_id')->constrained()->cascadeOnDelete();
            $table->enum('status', ['Pending', 'Filed', 'Overdue'])->default('Pending')->index();

            // ADT-1 Specific Fields
            $table->date('date_of_filing')->nullable();
            $table->string('srn')->nullable();
            $table->date('date_of_appointment')->nullable();

            // Updated fields per user request
            $table->date('agm_held')->nullable(); // Was boolean, now Date of AGM
            $table->date('from_year')->nullable(); // Was year, now Date
            $table->date('to_year')->nullable(); // Was year, now Date
            $table->date('due_date')->nullable(); // New column
            $table->integer('no_of_years')->nullable(); // New column (calculated)

            $table->string('name_of_signing_auditor')->nullable();
            $table->string('name_of_auditor_firm')->nullable();

            $table->timestamps();

            // Indexes for faster reporting
            $table->index(['company_id', 'financial_session_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('adt1_compliances');
    }
};
