<?php

namespace Database\Seeders;

use App\Models\Core\Company;
use App\Models\Core\ComplianceGroup;
use App\Models\Core\ComplianceType;
use App\Models\Core\FinancialSession;
use Illuminate\Database\Seeder;

class SystemSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // 1. Create Sessions
        $currentSession = FinancialSession::create([
            'name' => '2024-25',
            'start_date' => '2024-04-01',
            'end_date' => '2025-03-31',
            'is_active' => true,
            'status' => 'current',
        ]);

        $nextSession = FinancialSession::create([
            'name' => '2025-26',
            'start_date' => '2025-04-01',
            'end_date' => '2026-03-31',
            'is_active' => false,
            'status' => 'upcoming',
        ]);

        // 2. Create Group
        $rocGroup = ComplianceGroup::create([
            'name' => 'ROC',
            'code' => 'ROC',
        ]);

        // 3. Create Type
        $adt1Type = ComplianceType::create([
            'compliance_group_id' => $rocGroup->id,
            'name' => 'ADT-1',
            'code' => 'ADT1',
            'table_name' => 'adt1_compliances',
        ]);

        // 4. Create Company
        $company = Company::create([
            'name' => 'Praveen Aggarwal & Co.',
            'cin' => 'L12345DL1995PLC123456',
            'email' => 'info@praveen.co',
        ]);

        // 5. Link Company to Current Session
        $company->financialSessions()->attach($currentSession->id, ['status' => 'active']);

        $this->command->info('System seeded with: Session 2024-25, ROC Group, ADT-1 Type, and Test Company.');
    }
}
