@extends('admin.layouts.app')

@section('title', 'Edit Company')

@section('content')
    <div class="max-w-7xl mx-auto py-4 px-3">

        <!-- Header -->
        <div class="flex items-center justify-between mb-3">
            <h1 class="text-sm font-semibold text-gray-800 tracking-wide">
                Edit Company
            </h1>
            <a href="{{ route('admin.companies.index') }}"
                class="text-[11px] px-3 py-1 border border-gray-300 bg-gray-100 text-gray-700 rounded hover:bg-gray-200">
                ← Back
            </a>
        </div>

        <!-- Card -->
        <div class="bg-white border border-gray-300 rounded-md shadow-sm">

            <form action="{{ route('admin.companies.update', $company->id) }}" method="POST">
                @csrf
                @method('PUT')

                <!-- ROW 1 : CORE INFO -->
                <div class="grid grid-cols-1 md:grid-cols-4 gap-3 p-4 border-b bg-gray-50">

                    <div>
                        <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">
                            Financial Session <span class="text-red-500">*</span>
                        </label>
                        <select name="financial_year_id" required class="w-full text-xs px-2 py-1 border border-gray-300 rounded
                                focus:border-blue-500 focus:ring-0 bg-white">
                            <option value="">-- Select --</option>
                            @foreach ($financialYears as $year)
                                <option value="{{ $year->id }}" {{ $year->id == old('financial_year_id', $company->financialSessions->first()?->id) ? 'selected' : '' }}>
                                    {{ $year->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">
                            Company Name <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="company_name" value="{{ old('company_name', $company->name) }}" required
                            class="w-full text-xs px-2 py-1 border border-gray-300 rounded uppercase
                                focus:border-blue-500 focus:ring-0">
                    </div>

                    <div>
                        <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">
                            CIN
                        </label>
                        <input type="text" name="cin" value="{{ old('cin', $company->cin) }}" class="w-full text-xs px-2 py-1 border border-gray-300 rounded uppercase font-mono
                                focus:border-blue-500 focus:ring-0">
                    </div>

                    <div>
                        <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">
                            GSTIN
                        </label>
                        <input type="text" name="gstin" value="{{ old('gstin', $company->gstin) }}" class="w-full text-xs px-2 py-1 border border-gray-300 rounded uppercase font-mono
                                focus:border-blue-500 focus:ring-0">
                    </div>

                </div>

                <!-- ROW 2 : TAX / DATE -->
                <div class="grid grid-cols-1 md:grid-cols-4 gap-3 p-4 border-b">

                    <div>
                        <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">
                            Incorporation Date
                        </label>
                        <input type="date" name="date_of_incorporation"
                            value="{{ old('date_of_incorporation', $company->incorporation_date?->format('Y-m-d')) }}"
                            class="w-full text-xs px-2 py-1 border border-gray-300 rounded
                                focus:border-blue-500 focus:ring-0">
                    </div>

                    <div>
                        <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">
                            TAN
                        </label>
                        <input type="text" name="tan" value="{{ old('tan', $company->tan) }}" class="w-full text-xs px-2 py-1 border border-gray-300 rounded uppercase font-mono
                                focus:border-blue-500 focus:ring-0">
                    </div>

                    <div>
                        <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">
                            PAN
                        </label>
                        <input type="text" name="pan" value="{{ old('pan', $company->pan) }}" class="w-full text-xs px-2 py-1 border border-gray-300 rounded uppercase font-mono
                                focus:border-blue-500 focus:ring-0">
                    </div>

                    <div class="hidden md:block"></div>

                </div>

                <!-- ROW 3 : ADDRESS -->
                <div class="p-4">
                    <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">
                        Registered Office Address
                    </label>
                    <textarea name="registered_office_address" rows="2"
                        class="w-full text-xs px-2 py-1 border border-gray-300 rounded resize-none
                            focus:border-blue-500 focus:ring-0">{{ old('registered_office_address', $company->registered_office_address) }}</textarea>
                </div>

                <!-- ACTION BAR -->
                <div class="flex justify-end items-center gap-3 px-4 py-3 border-t bg-gray-50">
                    <button type="submit"
                        class="text-xs bg-blue-600 hover:bg-blue-700 text-white px-6 py-1.5 rounded font-semibold tracking-wide">
                        Update Company
                    </button>
                </div>

            </form>
        </div>
    </div>
@endsection