<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@yield('title', 'Dashboard') - {{ config('app.name') }}</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body class="min-h-screen bg-gray-50 font-sans antialiased">

    <!-- Premium Enterprise Header -->
    <header class="sticky top-0 z-50 bg-slate-900 border-b border-slate-800 shadow-md">
        <div class="max-w-7xl mx-auto px-6">
            <div class="flex items-center justify-between h-16">

                <!-- Left: Brand + Navigation -->
                <div class="flex items-center gap-10">
                    <!-- Brand -->
                    <div class="flex items-center gap-3">
                        <div
                            class="w-8 h-8 bg-blue-600 rounded-lg flex items-center justify-center shadow-lg shadow-blue-900/50">
                            <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                                    d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                            </svg>
                        </div>
                        <div>
                            <h1 class="text-base font-bold text-white tracking-wide">
                                Compliance<span class="text-blue-500">Tracker</span>
                            </h1>
                        </div>
                    </div>

                    <!-- Navigation -->
                    <nav class="hidden md:flex items-center gap-1">
                        <a href="{{ route('admin.dashboard') }}" class="inline-flex items-center gap-2 px-3 py-2 rounded-md text-sm font-medium transition-all duration-200
                                  {{ request()->routeIs('admin.dashboard')
    ? 'bg-slate-800 text-white shadow-sm ring-1 ring-white/10'
    : 'text-slate-400 hover:text-white hover:bg-white/5' }}">
                            <svg class="w-4 h-4 {{ request()->routeIs('admin.dashboard') ? 'text-blue-400' : 'text-slate-500 group-hover:text-slate-300' }}"
                                fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
                            </svg>
                            Dashboard
                        </a>

                        <a href="{{ route('admin.companies.index') }}" class="inline-flex items-center gap-2 px-3 py-2 rounded-md text-sm font-medium transition-all duration-200
                                  {{ request()->routeIs('admin.companies.*')
    ? 'bg-slate-800 text-white shadow-sm ring-1 ring-white/10'
    : 'text-slate-400 hover:text-white hover:bg-white/5' }}">
                            <svg class="w-4 h-4 {{ request()->routeIs('admin.companies.*') ? 'text-blue-400' : 'text-slate-500 group-hover:text-slate-300' }}"
                                fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                            </svg>
                            Companies
                        </a>

                        <a href="{{ route('admin.compliance-groups.index') }}" class="inline-flex items-center gap-2 px-3 py-2 rounded-md text-sm font-medium transition-all duration-200
                                  {{ request()->routeIs('admin.compliance-groups.*')
    ? 'bg-slate-800 text-white shadow-sm ring-1 ring-white/10'
    : 'text-slate-400 hover:text-white hover:bg-white/5' }}">
                            <svg class="w-4 h-4 {{ request()->routeIs('admin.compliance-groups.*') ? 'text-blue-400' : 'text-slate-500 group-hover:text-slate-300' }}"
                                fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2" />
                            </svg>
                            Compliance
                        </a>
                    </nav>
                </div>

                <!-- Right: User Info + Actions -->
                <div class="flex items-center gap-6">
                    <!-- Financial Year Badge -->
                    <div
                        class="hidden md:flex items-center gap-2 px-3 py-1 bg-slate-800/50 rounded-full border border-slate-700">
                        <div class="w-1.5 h-1.5 rounded-full bg-emerald-500 shadow-[0_0_8px_rgba(16,185,129,0.5)]">
                        </div>
                        <span class="text-xs font-medium text-slate-300">
                            FY: @php
                                $activeSession = \App\Models\Core\FinancialSession::where('is_active', true)->first();
                            @endphp
                            {{ $activeSession->name ?? 'N/A' }}
                        </span>
                    </div>

                    <!-- User Menu -->
                    <div class="flex items-center gap-4 pl-6 border-l border-slate-800">
                        <div class="text-right hidden md:block">
                            <p class="text-sm font-semibold text-slate-200">{{ auth()->user()->name ?? 'Admin' }}</p>
                            <p class="text-[10px] text-slate-500 uppercase tracking-wider font-semibold">Administrator
                            </p>
                        </div>

                        <div class="flex items-center gap-3">
                            <div
                                class="h-8 w-8 rounded-full bg-slate-700 border border-slate-600 flex items-center justify-center text-xs font-bold text-white">
                                {{ substr(auth()->user()->name ?? 'A', 0, 1) }}
                            </div>

                            <form method="POST" action="{{ route('admin.logout') }}">
                                @csrf
                                <button type="submit" class="text-slate-400 hover:text-white transition-colors"
                                    title="Logout">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                                    </svg>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </header>

    <!-- Main Content -->
    <main class="max-w-7xl mx-auto px-6 py-8">
        <!-- Alerts/Notifications -->
        @if (session('success'))
            <div class="mb-6 p-4 rounded-md bg-emerald-50 border border-emerald-200 flex items-start gap-3 shadow-sm"
                role="alert">
                <svg class="w-5 h-5 text-emerald-500 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <div class="flex-1">
                    <h3 class="text-sm font-medium text-emerald-800">Success</h3>
                    <div class="text-sm text-emerald-700 mt-1">{{ session('success') }}</div>
                </div>
            </div>
        @endif

        @if (session('error'))
            <div class="mb-6 p-4 rounded-md bg-red-50 border border-red-200 flex items-start gap-3 shadow-sm" role="alert">
                <svg class="w-5 h-5 text-red-500 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <div class="flex-1">
                    <h3 class="text-sm font-medium text-red-800">Error</h3>
                    <div class="text-sm text-red-700 mt-1">{{ session('error') }}</div>
                </div>
            </div>
        @endif

        @if ($errors->any())
            <div class="mb-6 p-4 rounded-md bg-red-50 border border-red-200 flex items-start gap-3 shadow-sm" role="alert">
                <svg class="w-5 h-5 text-red-500 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z">
                    </path>
                </svg>
                <div class="flex-1">
                    <h3 class="text-sm font-medium text-red-800">There were errors with your submission</h3>
                    <ul class="mt-1 list-disc list-inside text-sm text-red-700">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
        @endif

        @yield('content')
    </main>

    <!-- Footer -->
    <footer class="py-6 text-center text-xs text-slate-400 border-t border-slate-200 bg-white">
        © {{ date('Y') }} Praveen Aggarwal & Co. All rights reserved.
    </footer>

</body>

</html>