<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin Login - <?php echo e(config('app.name')); ?></title>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>

<body
    class="bg-slate-900 font-sans antialiased h-screen flex items-center justify-center selection:bg-indigo-500 selection:text-white">

    <div class="w-full max-w-md bg-slate-800 rounded-2xl shadow-2xl overflow-hidden border border-slate-700/50">

        <!-- Header -->
        <div class="bg-gradient-to-r from-indigo-900 to-slate-900 p-8 text-center border-b border-slate-700">
            <div class="mx-auto h-12 w-12 bg-indigo-500 rounded-xl flex items-center justify-center shadow-lg mb-4">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24"
                    stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                </svg>
            </div>
            <h2 class="text-2xl font-bold text-white tracking-tight">Admin Portal</h2>
            <p class="text-slate-400 text-sm mt-1">Secure Access Only</p>
        </div>

        <!-- Form -->
        <div class="p-8">
            <form method="POST" action="<?php echo e(route('admin.login')); ?>">
                <?php echo csrf_field(); ?>

                <!-- Session Status -->
                <?php if(session('status')): ?>
                    <div class="mb-4 font-medium text-sm text-green-400 text-center">
                        <?php echo e(session('status')); ?>

                    </div>
                <?php endif; ?>

                <!-- Email Address -->
                <div class="mb-5">
                    <label for="email" class="block text-sm font-medium text-slate-300 mb-2">Email Address</label>
                    <input id="email"
                        class="block w-full px-4 py-3 rounded-lg bg-slate-900 border border-slate-600 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition duration-200"
                        type="email" name="email" value="<?php echo e(old('email')); ?>" required autofocus autocomplete="username"
                        placeholder="admin@example.com" />
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-2 text-sm text-red-400"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Password -->
                <div class="mb-6">
                    <label for="password" class="block text-sm font-medium text-slate-300 mb-2">Password</label>
                    <input id="password"
                        class="block w-full px-4 py-3 rounded-lg bg-slate-900 border border-slate-600 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition duration-200"
                        type="password" name="password" required autocomplete="current-password"
                        placeholder="••••••••" />
                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-2 text-sm text-red-400"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Remember Me -->
                <div class="flex items-center justify-between mb-6">
                    <label for="remember_me" class="inline-flex items-center">
                        <input id="remember_me" type="checkbox"
                            class="rounded border-slate-600 bg-slate-900 text-indigo-500 shadow-sm focus:ring-indigo-500/50"
                            name="remember">
                        <span
                            class="ms-2 text-sm text-slate-400 hover:text-slate-300 cursor-pointer transition">Remember
                            me</span>
                    </label>
                </div>

                <!-- Submit Button -->
                <div>
                    <button type="submit"
                        class="w-full flex justify-center py-3 px-4 border border-transparent rounded-lg shadow-sm text-sm font-bold text-white bg-indigo-600 hover:bg-indigo-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 focus:ring-offset-slate-800 transition duration-200 transform hover:scale-[1.02]">
                        Sign In
                    </button>
                </div>
            </form>
        </div>

        <!-- Footer -->
        <div class="bg-slate-900/50 p-4 border-t border-slate-700 text-center">
            <p class="text-xs text-slate-500">&copy; <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. All rights reserved.</p>
        </div>
    </div>

</body>

</html><?php /**PATH E:\praveen-aggarwal-co\resources\views/admin/auth/login.blade.php ENDPATH**/ ?>