

<?php $__env->startSection('title', $complianceGroup->name); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-7xl mx-auto py-4 px-3">

        <!-- Header -->
        <div class="flex items-center justify-between mb-6">
            <div>
                <h1 class="text-lg font-bold text-gray-900 tracking-tight">
                    <?php echo e($complianceGroup->name); ?>

                </h1>
                <p class="text-xs text-gray-500 mt-1">Manage compliance types under <?php echo e($complianceGroup->code); ?></p>
            </div>
            <a href="<?php echo e(route('admin.dashboard')); ?>"
                class="text-[11px] px-3 py-1 border border-gray-300 bg-gray-100 text-gray-700 rounded hover:bg-gray-200">
                ← Dashboard
            </a>
        </div>

        <!-- Active Compliance Modules -->
        <div class="mt-8">
            <?php if($complianceGroup->complianceTypes->count() > 0): ?>
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
                    <?php $__currentLoopData = $complianceGroup->complianceTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $stats = $moduleStats[$type->id] ?? ['pending' => 0, 'filed' => 0];
                            $isPending = $stats['pending'] > 0;
                        ?>

                        <!-- Compact Card -->
                        <div class="relative bg-white rounded-lg shadow-sm border border-gray-200 p-4 hover:shadow-md hover:border-blue-300 transition-all duration-200 group flex flex-col justify-between min-h-[140px]">
                            
                            <!-- Link -->
                            <?php if($type->code === 'ADT1'): ?>
                                <a href="<?php echo e(route('admin.adt1.index')); ?>" class="absolute inset-0 z-10"></a>
                            <?php endif; ?>

                            <!-- Header -->
                            <div class="flex justify-between items-start">
                                <div class="p-2 bg-blue-50 text-blue-600 rounded-md">
                                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                                    </svg>
                                </div>
                                
                                <!-- Status Indicator -->
                                <?php if($isPending): ?>
                                    <div class="flex items-center gap-1 bg-red-50 text-red-600 px-2 py-1 rounded-full border border-red-100">
                                        <span class="relative flex h-2 w-2">
                                          <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-red-400 opacity-75"></span>
                                          <span class="relative inline-flex rounded-full h-2 w-2 bg-red-500"></span>
                                        </span>
                                        <span class="text-[10px] font-bold uppercase"><?php echo e($stats['pending']); ?> Pending</span>
                                    </div>
                                <?php else: ?>
                                    <div class="text-green-500 bg-green-50 p-1 rounded-full">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" /></svg>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <!-- Content -->
                            <div class="mt-3">
                                <h3 class="text-base font-bold text-gray-900 leading-tight group-hover:text-blue-600 transition-colors">
                                    <?php echo e($type->name); ?>

                                </h3>
                                <p class="text-[11px] text-gray-500 mt-1 line-clamp-2">Manage appointments & filings</p>
                            </div>

                            <!-- Footer -->
                            <div class="mt-4 pt-3 border-t border-gray-100 flex items-center justify-between text-xs">
                                <span class="text-gray-500 font-medium">Total: <?php echo e($stats['filed'] + $stats['pending']); ?></span>
                                <span class="text-blue-600 font-semibold group-hover:translate-x-1 transition-transform flex items-center">
                                    Open <svg class="w-3 h-3 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" /></svg>
                                </span>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="py-12 text-center bg-gray-50 rounded-lg border border-dashed border-gray-300">
                    <p class="text-xs text-gray-500 italic">No compliance types found for this group.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\praveen-aggarwal-co\resources\views/admin/compliance-groups/show.blade.php ENDPATH**/ ?>