<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class StoreAdt1ComplianceRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->can('create', \App\Models\Compliances\Adt1Compliance::class);
    }

    public function rules(): array
    {
        return [
            'status' => 'required|in:Filed,Pending,Overdue',
            'date_of_filing' => 'nullable|date_format:d/m/Y',
            // 'due_date' => 'nullable|date', // Calculated automatically
            'srn' => 'nullable|string|max:255',
            'date_of_appointment' => 'nullable|date_format:d/m/Y',
            'agm_held' => 'nullable|date_format:d/m/Y',
            'from_year' => 'nullable|date_format:d/m/Y',
            'to_year' => 'nullable|date_format:d/m/Y',
            'no_of_years' => 'nullable|integer',
            'name_of_signing_auditor' => 'nullable|string|max:255',
            'name_of_auditor_firm' => 'nullable|string|max:255',
        ];
    }
}
