<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class StoreCompanyRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->can('create', \App\Models\Core\Company::class);
    }

    public function rules(): array
    {
        return [
            'company_name' => 'required|string|max:255',
            'cin' => 'nullable|string|max:21|unique:companies,cin',
            'pan' => 'nullable|string|max:10',
            'tan' => 'nullable|string|max:10',
            'registered_office_address' => 'nullable|string',
            'date_of_incorporation' => 'nullable|date',
            'gstin' => 'nullable|string|max:15',
            'email' => 'nullable|email|max:255',
            'financial_year_id' => 'required|exists:financial_sessions,id',
        ];
    }
}
