<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateCompanyRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->can('update', $this->route('company'));
    }

    public function rules(): array
    {
        $companyId = $this->route('company')->id;

        return [
            'company_name' => 'required|string|max:255',
            'cin' => [
                'nullable',
                'string',
                'max:21',
                Rule::unique('companies', 'cin')->ignore($companyId),
            ],
            'pan' => 'nullable|string|max:10',
            'tan' => 'nullable|string|max:10',
            'registered_office_address' => 'nullable|string',
            'date_of_incorporation' => 'nullable|date',
            'gstin' => 'nullable|string|max:15',
            'email' => 'nullable|email|max:255',
            'financial_year_id' => 'nullable|exists:financial_sessions,id',
        ];
    }
}
