<?php

namespace App\Models\Core;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ComplianceType extends Model
{
    use HasFactory;

    protected $fillable = [
        'compliance_group_id',
        'name',
        'code',
        'table_name',
        'priority',
    ];

    /**
     * Get the compliance group that owns the type.
     */
    public function group(): BelongsTo
    {
        return $this->belongsTo(ComplianceGroup::class, 'compliance_group_id');
    }
}
