<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('companies', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('cin')->unique()->nullable(); // Corporate Identification Number
            $table->string('pan')->nullable(); // Permanent Account Number
            $table->string('tan')->nullable(); // Tax Deduction Account Number
            $table->text('registered_office_address')->nullable();
            $table->date('incorporation_date')->nullable();
            $table->string('gstin')->nullable(); // Goods and Services Tax Identification Number
            $table->string('email')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('companies');
    }
};
