<?php

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\Core\FinancialSession;
use App\Models\Core\Company;
use App\Models\Core\ComplianceGroup;

// 1. Check Active Session
$activeSession = FinancialSession::where('is_active', true)->first();
echo "Active Session: " . ($activeSession ? $activeSession->name . " (ID: $activeSession->id)" : "NONE") . "\n";

if (!$activeSession) {
    echo "No active session found. Exiting.\n";
    exit;
}

// 2. Check Compliance Groups
$groups = ComplianceGroup::where('is_active', true)->get();
echo "Active Groups: " . $groups->count() . "\n";

foreach ($groups as $group) {
    echo "Group: {$group->name} (Code: '{$group->code}')\n";

    if ($group->code === 'ROC') {
        echo "  -> Processing ROC logic...\n";

        // 3. Check Companies in Session
        $companiesInSession = Company::whereHas('financialSessions', function ($q) use ($activeSession) {
            $q->where('financial_sessions.id', $activeSession->id);
        })->get(); // Get actual models to inspect

        $totalCompanies = $companiesInSession->count();
        echo "  -> Total Companies in Session {$activeSession->name}: $totalCompanies\n";

        if ($totalCompanies === 0) {
            echo "     WARNING: No companies found linked to session ID {$activeSession->id}.\n";
            // Check if companies exist at all
            echo "     Total Companies in DB: " . Company::count() . "\n";

            // Check a sample company and its sessions
            $sample = Company::first();
            if ($sample) {
                echo "     Sample Company: {$sample->name} (ID: {$sample->id})\n";
                echo "     Linked Sessions: " . $sample->financialSessions->pluck('id')->implode(', ') . "\n";
            }
        }

        // 4. Check Filed Count
        $filedCount = Company::whereHas('financialSessions', function ($q) use ($activeSession) {
            $q->where('financial_sessions.id', $activeSession->id);
        })->whereHas('adt1Compliances', function ($q) use ($activeSession) {
            $q->where('financial_session_id', $activeSession->id)
                ->where('status', 'Filed');
        })->count();

        echo "  -> Filed Count: $filedCount\n";
    } else {
        echo "  -> Skipping (Code mismatch)\n";
    }
    echo "------------------------------------------------\n";
}
