@extends('admin.layouts.app')

@section('title', 'File ADT-1')

@section('content')
    <style>
        input.border-red-500:focus {
            outline: none;
            --tw-ring-color: #ef4444;
            /* red-500 */
        }

        input.border-green-500:focus {
            outline: none;
            --tw-ring-color: #22c55e;
            /* green-500 */
        }
    </style>
    <div class="max-w-4xl mx-auto py-4 px-3">

        <!-- Header -->
        <div class="flex items-center justify-between mb-3">
            <div>
                <h1 class="text-sm font-semibold text-gray-800 tracking-wide">
                    File ADT-1
                </h1>
                <p class="text-[10px] text-gray-500 mt-0.5"> Appointment of Auditor - Form ADT-1</p>
            </div>

            <a href="{{ route('admin.adt1.index', ['session_id' => $session->id]) }}"
                class="text-[11px] px-3 py-1 border border-gray-300 bg-gray-100 text-gray-700 rounded hover:bg-gray-200">
                ← Back to Checklist
            </a>
        </div>


        <!-- Error Handling -->
        @if ($errors->any())
            <div class="mb-4 p-4 bg-red-50 border-l-4 border-red-500 text-red-700 rounded shadow-sm">
                <div class="flex items-center gap-2 mb-1">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                    </svg>
                    <h3 class="font-bold text-sm">Action Failed</h3>
                </div>
                <ul class="list-disc list-inside text-xs space-y-0.5 ml-1">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <!-- Main Card -->
        <div class="bg-white border border-gray-300 rounded-md shadow-sm">

            <!-- Context Header -->
            <div class="bg-gray-50 px-4 py-3 border-b border-gray-200 flex items-center justify-between">
                <div>
                    <span class="block text-[10px] font-semibold text-gray-500 uppercase">Company</span>
                    <span class="block text-xs font-bold text-gray-900">{{ $company->name }}</span>
                    <span class="block text-[10px] font-mono text-gray-500">{{ $company->cin }}</span>
                </div>
                <div class="text-right">
                    <span class="block text-[10px] font-semibold text-gray-500 uppercase">Financial Session</span>
                    <span class="block text-xs font-bold text-blue-700">{{ $session->name }}</span>
                </div>
            </div>

            <form action="{{ route('admin.adt1.store', ['company' => $company->id, 'session' => $session->id]) }}"
                method="POST">
                @csrf

                <div class="p-4 grid grid-cols-1 md:grid-cols-2 gap-4">

                    <!-- SECTION 1: Filing Details -->
                    <div class="col-span-full">
                        <h3 class="text-xs font-bold text-gray-800 border-b pb-1 mb-3">1. Filing Details</h3>
                    </div>

                    <!-- Status -->
                    <div>
                        <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">Filing Status <span
                                class="text-red-500">*</span></label>
                        <select name="status" required
                            class="w-full text-xs px-2 py-1.5 border border-gray-300 rounded focus:border-blue-500 focus:ring-0">
                            <option value="Pending" {{ old('status', $record->status ?? '') == 'Pending' ? 'selected' : '' }}>
                                Pending</option>
                            <option value="Filed" {{ old('status', $record->status ?? '') == 'Filed' ? 'selected' : '' }}>
                                Filed</option>
                            <option value="Overdue" {{ old('status', $record->status ?? '') == 'Overdue' ? 'selected' : '' }}>
                                Overdue</option>
                        </select>
                    </div>

                    <!-- Filing Date -->
                    <div>
                        <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">Date of Filing</label>
                        <input type="text" name="date_of_filing" placeholder="dd/mm/yyyy"
                            oninput="window.safeDateInput(this)"
                            value="{{ old('date_of_filing', optional($record->date_of_filing ?? null)->format('d/m/Y')) }}"
                            class="w-full text-xs px-2 py-1.5 border border-gray-300 rounded focus:border-blue-500 focus:ring-0">
                    </div>

                    <!-- SRN -->
                    <div>
                        <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">SRN</label>
                        <input type="text" name="srn" value="{{ old('srn', $record->srn ?? '') }}"
                            class="w-full text-xs px-2 py-1.5 border border-gray-300 rounded focus:border-blue-500 focus:ring-0 uppercase font-mono"
                            placeholder="e.g. F12345678">
                    </div>

                    <!-- Due Date (New) -->


                    <!-- SECTION 2: Appointment Details -->
                    <div class="col-span-full mt-2">
                        <h3 class="text-xs font-bold text-gray-800 border-b pb-1 mb-3">2. Appointment Details</h3>
                    </div>

                    <!-- Date of Appointment -->
                    <div>
                        <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">Date of Appointment</label>
                        <input type="text" name="date_of_appointment" placeholder="dd/mm/yyyy"
                            oninput="window.safeDateInput(this)"
                            value="{{ old('date_of_appointment', optional($record->date_of_appointment ?? null)->format('d/m/Y')) }}"
                            class="w-full text-xs px-2 py-1.5 border border-gray-300 rounded focus:border-blue-500 focus:ring-0">
                    </div>

                    <!-- AGM Date (Changed from Checkbox) -->
                    <div>
                        <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">Date of AGM</label>
                        <input type="text" name="agm_held" placeholder="dd/mm/yyyy" oninput="window.safeDateInput(this)"
                            value="{{ old('agm_held', optional($record->agm_held ?? null)->format('d/m/Y')) }}"
                            class="w-full text-xs px-2 py-1.5 border border-gray-300 rounded focus:border-blue-500 focus:ring-0">
                    </div>

                    <!-- Tenure -->
                    <div class="col-span-full grid grid-cols-3 gap-4">
                        <!-- From Date (Changed from Year) -->
                        <div>
                            <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">From Date</label>
                            <input type="text" name="from_year" id="from_year" placeholder="dd/mm/yyyy"
                                oninput="window.safeDateInput(this)"
                                value="{{ old('from_year', optional($record->from_year ?? null)->format('d/m/Y')) }}"
                                class="w-full text-xs px-2 py-1.5 border border-gray-300 rounded focus:border-blue-500 focus:ring-0">
                        </div>

                        <!-- To Date (Changed from Year) -->
                        <div>
                            <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">To Date</label>
                            <input type="text" name="to_year" id="to_year" placeholder="dd/mm/yyyy"
                                oninput="window.safeDateInput(this)"
                                value="{{ old('to_year', optional($record->to_year ?? null)->format('d/m/Y')) }}"
                                class="w-full text-xs px-2 py-1.5 border border-gray-300 rounded focus:border-blue-500 focus:ring-0">
                        </div>

                        <!-- No of Years (Calculated field) -->
                        <div>
                            <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">Tenure (Years)</label>
                            <input type="number" name="no_of_years" id="no_of_years"
                                value="{{ old('no_of_years', $record->no_of_years ?? '') }}" readonly
                                class="w-full text-xs px-2 py-1.5 border border-gray-300 bg-gray-100 rounded text-gray-600 cursor-not-allowed">
                        </div>
                    </div>

                    <div>
                        <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">Due Filing Date
                            (Auto-Calculated)</label>
                        <input type="text" name="due_date" id="due_date" readonly placeholder="dd/mm/yyyy"
                            value="{{ old('due_date', optional($record->due_date ?? null)->format('d/m/Y')) }}"
                            class="w-full text-xs px-2 py-1.5 border border-gray-300 bg-gray-100 rounded text-gray-600 cursor-not-allowed focus:border-blue-500 focus:ring-0">

                    </div>

                    <!-- SECTION 3: Auditor Details -->
                    <div class="col-span-full mt-2">
                        <h3 class="text-xs font-bold text-gray-800 border-b pb-1 mb-3">3. Auditor Information</h3>
                    </div>

                    <div>
                        <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">Auditor/Firm Name</label>
                        <input type="text" name="name_of_auditor_firm"
                            value="{{ old('name_of_auditor_firm', $record->name_of_auditor_firm ?? '') }}"
                            class="w-full text-xs px-2 py-1.5 border border-gray-300 rounded focus:border-blue-500 focus:ring-0"
                            placeholder="e.g. MSKA & Associates">
                    </div>

                    <div>
                        <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">Signing Partner Name</label>
                        <input type="text" name="name_of_signing_auditor"
                            value="{{ old('name_of_signing_auditor', $record->name_of_signing_auditor ?? '') }}"
                            class="w-full text-xs px-2 py-1.5 border border-gray-300 rounded focus:border-blue-500 focus:ring-0"
                            placeholder="e.g. John Doe">
                    </div>

                </div>

                <!-- ACTION BAR -->
                <div class="flex justify-between items-center px-4 py-3 border-t bg-gray-50 rounded-b-md">
                    <div class="text-[10px] text-gray-500 italic">
                        * Required fields (Format: dd/mm/yyyy)
                    </div>
                    <div class="flex gap-2">
                        <a href="{{ route('admin.adt1.index', ['session_id' => $session->id]) }}"
                            class="text-xs px-4 py-1.5 border border-gray-300 bg-white text-gray-700 rounded hover:bg-gray-50">
                            Cancel
                        </a>
                        <button type="submit"
                            class="text-xs bg-blue-600 hover:bg-blue-700 text-white px-6 py-1.5 rounded font-semibold tracking-wide shadow-sm">
                            Save ADT-1 Filing
                        </button>
                    </div>
                </div>

            </form>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const fromInput = document.getElementById('from_year');
            const toInput = document.getElementById('to_year');
            const tenureInput = document.getElementById('no_of_years');
            const dueInput = document.getElementById('due_date');

            // 1. Smart Input Masking (Auto-Slash & Strict Limits)
            // Exposed globally so inline oninput can call it
            window.safeDateInput = function (input) {
                let v = input.value;

                // Keep only numbers
                v = v.replace(/\D/g, '');

                // Limit length to 8 digits (ddmmyyyy = 8 chars)
                if (v.length > 8) v = v.slice(0, 8);

                // Add Slashes
                // If has day
                if (v.length >= 2) {
                    // Validate Day
                    const day = parseInt(v.slice(0, 2));
                    if (day > 31) {
                        // If user types > 31, maybe clamp or just let validation handle?
                        // User said "not acceptable". Let's clamp or stop.
                        // But typing "4" then "0" -> 40? 
                        // Better to just Format. Real-time blocking is annoying if it prevents correction.
                        // We will format 12122025 -> 12/12/2025
                    }
                    v = v.slice(0, 2) + '/' + v.slice(2);
                }

                // If has month
                if (v.length >= 5) {
                    v = v.slice(0, 5) + '/' + v.slice(5);
                }

                input.value = v;

                // Validate Logic immediately
                validateInput(input);
            };

            // 2. Strict Validation Logic
            function parseValidDate(str) {
                if (!str) return null;
                if (str.length !== 10) return null; // Must be full date

                const parts = str.split('/');
                if (parts.length !== 3) return null;

                const day = parseInt(parts[0], 10);
                const month = parseInt(parts[1], 10);
                const year = parseInt(parts[2], 10);

                if (isNaN(day) || isNaN(month) || isNaN(year)) return null;

                // Strict Ranges
                if (month < 1 || month > 12) return null;
                if (day < 1 || day > 31) return null;
                // Year reasonable range (e.g. 1900-2100)?
                if (year < 1900 || year > 2100) return null;

                // Date Object check for validity (e.g. 30/02)
                const date = new Date(year, month - 1, day);
                if (date.getFullYear() === year && date.getMonth() === (month - 1) && date.getDate() === day) {
                    return date;
                }
                return null;
            }

            function validateInput(input) {
                const val = input.value;
                if (!val) {
                    input.classList.remove('border-red-500', 'focus:border-red-500', 'border-green-500', 'focus:border-green-500');
                    return;
                }

                // Check strict
                if (parseValidDate(val)) {
                    input.classList.remove('border-red-500', 'focus:border-red-500');
                    input.classList.add('border-green-500', 'focus:border-green-500');
                } else {
                    input.classList.remove('border-green-500', 'focus:border-green-500');
                    input.classList.add('border-red-500', 'focus:border-red-500');
                }

                // Trigger Calc
                if (input === fromInput || input === toInput) calculateYears();
            }

            // 3. Calculation Logic (STRICT)
            function calculateYears() {
                const fromDate = parseValidDate(fromInput.value);
                const toDate = parseValidDate(toInput.value);

                if (fromDate && toDate) {
                    // Logic: Tenure is difference in Years
                    let years = toDate.getFullYear() - fromDate.getFullYear();
                    // Ensure non-negative
                    tenureInput.value = years >= 0 ? years : 0;
                } else {
                    tenureInput.value = '';
                }
                calculateDueDate();
            }

            function calculateDueDate() {
                const toDate = parseValidDate(toInput.value);

                if (toDate) {
                    // Logic: Actual Due Date = To Date + 6 Months
                    // Example: To Date 30/09/2025 -> Due Date 30/03/2026? 
                    // Or usually financial year logic? 
                    // User said: "Actual Due Date = To Date + 6 months" strictly.
                    
                    const due = new Date(toDate.getTime());
                    due.setMonth(due.getMonth() + 6);

                    // Handle edge cases like 31st vs 30th (JS handles overflow automatically, e.g. 31/08 + 1 month -> 01/10)
                    // But typically +6 months from 31/03 is 30/09.
                    // Let's rely on standard JS date math which is "add months". 
                    // If current day > days in target month, standard behavior is spill over.
                    // Typically for compliance dates, we want end of month? 
                    // User said: "Actual Due Date = To Date + 6 months". We will stick to strict date addition.

                    const d = String(due.getDate()).padStart(2, '0');
                    const m = String(due.getMonth() + 1).padStart(2, '0');
                    const y = due.getFullYear();

                    dueInput.value = `${d}/${m}/${y}`;
                } else {
                    dueInput.value = '';
                }
            }

            // Initial
            calculateYears();

            // Re-validate all existing inputs
            document.querySelectorAll('input[placeholder="dd/mm/yyyy"]').forEach(validateInput);
        });
    </script>
@endsection