@extends('admin.layouts.app')

@section('title', 'Company Details')

@section('content')
    <div class="max-w-7xl mx-auto py-4 px-3">
        <!-- Header -->
        <div class="flex items-center justify-between mb-3">
            <h1 class="text-sm font-semibold text-gray-800 tracking-wide">
                Company Details
            </h1>
            <div class="flex items-center gap-2">
                <a href="{{ route('admin.companies.index') }}"
                    class="text-[11px] px-3 py-1 border border-gray-300 bg-gray-100 text-gray-700 rounded hover:bg-gray-200">
                    ← Back
                </a>
                <a href="{{ route('admin.companies.edit', $company->id) }}"
                    class="text-[11px] px-3 py-1 border border-blue-600 bg-blue-600 text-white rounded hover:bg-blue-700">
                    Edit Company
                </a>
            </div>
        </div>

        <!-- Main Card -->
        <div class="bg-white border border-gray-300 rounded-md shadow-sm">

            <!-- ROW 1 : CORE INFO -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-3 p-4 border-b bg-gray-50">
                <div>
                    <span class="block text-[10px] font-semibold text-gray-500 uppercase">Company Name</span>
                    <span class="block text-xs font-bold text-gray-900 mt-0.5">{{ $company->name }}</span>
                </div>

                <div>
                    <span class="block text-[10px] font-semibold text-gray-500 uppercase">Official Email</span>
                    <span class="block text-xs font-medium text-gray-900 mt-0.5">{{ $company->email ?? 'N/A' }}</span>
                </div>

                <div>
                    <span class="block text-[10px] font-semibold text-gray-500 uppercase">Incorporation Date</span>
                    <span class="block text-xs font-medium text-gray-900 mt-0.5">
                        {{ $company->incorporation_date ? $company->incorporation_date->format('d M Y') : 'N/A' }}
                    </span>
                </div>

                <div>
                    <span class="block text-[10px] font-semibold text-gray-500 uppercase">Active Sessions</span>
                    <div class="flex flex-wrap gap-1 mt-1">
                        @if($company->financialSessions->count() > 0)
                            @foreach($company->financialSessions as $session)
                                <span
                                    class="inline-flex items-center px-1.5 py-0.5 rounded text-[10px] font-medium 
                                                   {{ $session->is_active ? 'bg-green-100 text-green-800 border border-green-200' : 'bg-gray-100 text-gray-600 border border-gray-200' }}">
                                    {{ $session->name }}
                                </span>
                            @endforeach
                        @else
                            <span class="text-[10px] text-gray-400 italic">None</span>
                        @endif
                    </div>
                </div>
            </div>

            <!-- ROW 2 : IDENTIFIERS -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-3 p-4 border-b">
                <div>
                    <span class="block text-[10px] font-semibold text-gray-500 uppercase">CIN</span>
                    <span class="block text-xs font-mono text-gray-900 mt-0.5">{{ $company->cin ?? 'N/A' }}</span>
                </div>
                <div>
                    <span class="block text-[10px] font-semibold text-gray-500 uppercase">PAN</span>
                    <span class="block text-xs font-mono text-gray-900 mt-0.5">{{ $company->pan ?? 'N/A' }}</span>
                </div>
                <div>
                    <span class="block text-[10px] font-semibold text-gray-500 uppercase">TAN</span>
                    <span class="block text-xs font-mono text-gray-900 mt-0.5">{{ $company->tan ?? 'N/A' }}</span>
                </div>
                <div>
                    <span class="block text-[10px] font-semibold text-gray-500 uppercase">GSTIN</span>
                    <span class="block text-xs font-mono text-gray-900 mt-0.5">{{ $company->gstin ?? 'N/A' }}</span>
                </div>
            </div>

            <!-- ROW 3 : ADDRESS -->
            <div class="p-4 bg-gray-50/50">
                <span class="block text-[10px] font-semibold text-gray-500 uppercase mb-1">Registered Office Address</span>
                <div class="text-xs text-gray-700 whitespace-pre-line leading-relaxed">
                    {{ $company->registered_office_address ?? 'No address provided.' }}
                </div>
            </div>
        </div>
    </div>
@endsection