@extends('admin.layouts.app')

@section('title', 'Edit Compliance Group')

@section('content')
    <div class="max-w-2xl mx-auto py-4 px-3">

        <!-- Header -->
        <div class="flex items-center justify-between mb-3">
            <h1 class="text-sm font-semibold text-gray-800 tracking-wide">
                Edit Compliance Group
            </h1>
            <a href="{{ route('admin.compliance-groups.index') }}"
                class="text-[11px] px-3 py-1 border border-gray-300 bg-gray-100 text-gray-700 rounded hover:bg-gray-200">
                ← Back
            </a>
        </div>

        <!-- Card -->
        <div class="bg-white border border-gray-300 rounded-md shadow-sm">

            <form action="{{ route('admin.compliance-groups.update', $complianceGroup->id) }}" method="POST">
                @csrf
                @method('PUT')

                <!-- FORM FIELDS -->
                <div class="p-4 space-y-4">

                    <!-- Name -->
                    <div>
                        <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">
                            Group Name <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="name" value="{{ old('name', $complianceGroup->name) }}" required
                            class="w-full text-xs px-2 py-1.5 border border-gray-300 rounded focus:border-blue-500 focus:ring-0">
                        @error('name') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
                    </div>

                    <!-- Code -->
                    <div>
                        <label class="block text-[11px] font-semibold text-gray-700 mb-0.5">
                            Group Code <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="code" value="{{ old('code', $complianceGroup->code) }}" required
                            class="w-full text-xs px-2 py-1.5 border border-gray-300 rounded focus:border-blue-500 focus:ring-0 uppercase font-mono">
                        <p class="mt-1 text-[10px] text-gray-500">Unique identifier for this group (Uppercase).</p>
                        @error('code') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
                    </div>

                    <!-- Active Status -->
                    <div class="flex items-center gap-2 mt-2">
                        <input type="checkbox" name="is_active" id="is_active" value="1" {{ old('is_active', $complianceGroup->is_active) ? 'checked' : '' }}
                            class="h-4 w-4 text-blue-600 rounded border-gray-300 focus:ring-blue-500">
                        <label for="is_active" class="text-xs text-gray-700 font-medium">Active</label>
                    </div>

                </div>

                <!-- ACTION BAR -->
                <div class="flex justify-end items-center gap-3 px-4 py-3 border-t bg-gray-50">
                    <button type="submit"
                        class="text-xs bg-blue-600 hover:bg-blue-700 text-white px-6 py-1.5 rounded font-semibold tracking-wide">
                        Update Group
                    </button>
                </div>

            </form>
        </div>
    </div>
@endsection