@extends('admin.layouts.app')

@section('title', 'Compliance Groups')

@section('content')
    <div class="max-w-7xl mx-auto py-4 px-3">

        <!-- Header -->
        <div class="flex items-center justify-between mb-3">
            <h1 class="text-sm font-semibold text-gray-800 tracking-wide">
                Compliance Groups
            </h1>
            <a href="{{ route('admin.compliance-groups.create') }}"
                class="text-[11px] px-3 py-1 border border-blue-600 bg-blue-600 text-white rounded hover:bg-blue-700">
                + Add Group
            </a>
        </div>

        <!-- Search Bar -->
        <div class="mb-4">
            <form method="GET" action="{{ route('admin.compliance-groups.index') }}" class="h-8">
                <div class="flex h-full w-full md:w-1/3">
                    <input type="text" name="search" value="{{ request('search') }}" placeholder="Search by Name or Code..."
                        class="flex-1 h-full text-xs px-3 border border-gray-300 rounded-l focus:border-blue-500 focus:ring-0">
                    <button type="submit"
                        class="bg-gray-100 border border-l-0 border-gray-300 text-gray-600 px-4 rounded-r hover:bg-gray-200 text-xs font-semibold">
                        Search
                    </button>
                    @if(request('search'))
                        <a href="{{ route('admin.compliance-groups.index') }}"
                            class="ml-2 flex items-center justify-center px-3 border border-red-200 bg-red-50 text-red-600 rounded hover:bg-red-100 text-xs">
                            Clear
                        </a>
                    @endif
                </div>
            </form>
        </div>

        <!-- Main Card -->
        <div class="bg-white border border-gray-300 rounded-md shadow-sm">

            @if(session('success'))
                <div class="bg-green-50 text-green-800 text-xs px-4 py-2 border-b border-green-100">
                    {{ session('success') }}
                </div>
            @endif

            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50 border-b border-gray-200">
                        <tr>
                            <th class="px-4 py-2 text-left text-[10px] font-bold text-gray-600 uppercase tracking-wider">
                                Group Name</th>
                            <th class="px-4 py-2 text-left text-[10px] font-bold text-gray-600 uppercase tracking-wider">
                                Code</th>
                            <th class="px-4 py-2 text-center text-[10px] font-bold text-gray-600 uppercase tracking-wider">
                                Status</th>
                            <th class="px-4 py-2 text-center text-[10px] font-bold text-gray-600 uppercase tracking-wider">
                                Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($groups as $group)
                            <tr class="hover:bg-slate-50">
                                <td class="px-4 py-2">
                                    <div class="text-xs font-semibold text-gray-900">{{ $group->name }}</div>
                                </td>
                                <td class="px-4 py-2">
                                    <span
                                        class="text-xs font-mono bg-gray-100 border border-gray-200 px-1.5 py-0.5 rounded text-gray-700">
                                        {{ $group->code }}
                                    </span>
                                </td>
                                <td class="px-4 py-2 text-center">
                                    @if($group->is_active)
                                        <span
                                            class="inline-flex items-center px-1.5 py-0.5 rounded text-[10px] font-medium bg-green-100 text-green-800 border border-green-200">
                                            Active
                                        </span>
                                    @else
                                        <span
                                            class="inline-flex items-center px-1.5 py-0.5 rounded text-[10px] font-medium bg-gray-100 text-gray-600 border border-gray-200">
                                            Inactive
                                        </span>
                                    @endif
                                </td>
                                <td class="px-4 py-2 text-center">
                                    <div class="flex items-center justify-center gap-2">
                                        <a href="{{ route('admin.compliance-groups.edit', $group->id) }}"
                                            class="text-gray-500 hover:text-blue-600 transition" title="Edit">
                                            <svg class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                                            </svg>
                                        </a>
                                        <form action="{{ route('admin.compliance-groups.destroy', $group->id) }}" method="POST"
                                            class="inline" onsubmit="return confirm('Delete this group?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-gray-500 hover:text-red-600 transition"
                                                title="Delete">
                                                <svg class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                                </svg>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="px-4 py-8 text-center text-xs text-gray-500">
                                    No compliance groups found.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            @if($groups->hasPages())
                <div class="border-t border-gray-200 px-4 py-3 bg-gray-50">
                    {{ $groups->links() }}
                </div>
            @endif
        </div>
    </div>
@endsection