@extends('admin.layouts.app')

@section('page-title', 'Dashboard')

@section('content')
    <div class="max-w-[1600px] mx-auto py-6 px-4">

        <!-- Welcome Section -->
        <div class="mb-6 flex items-end justify-between">
            <div>
                <h1 class="text-2xl font-bold text-slate-900 tracking-tight">
                    Dashboard
                </h1>
                <p class="text-xs text-slate-500 mt-1 font-medium">
                    Overview of your compliance groups.
                </p>
            </div>
            <div class="hidden sm:block">
                <span class="inline-flex items-center gap-1.5 px-3 py-1 rounded-full bg-white border border-slate-200 shadow-sm text-[10px] font-semibold text-slate-600">
                    <svg class="w-3 h-3 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                    </svg>
                    {{ now()->format('M j, Y') }}
                </span>
            </div>
        </div>

        <!-- Compliance Groups Grid -->
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-5 2xl:grid-cols-6 gap-4">

            @forelse($complianceGroups as $group)
                <a href="{{ route('admin.compliance-groups.show', $group->id) }}"
                    class="group relative flex flex-col h-full bg-white rounded-xl shadow-sm border border-slate-100 hover:shadow-lg hover:-translate-y-0.5 transition-all duration-200 ease-in-out cursor-pointer overflow-hidden ring-1 ring-slate-900/5">
                    
                    <!-- Decorative Top Bar -->
                    <div class="absolute top-0 left-0 right-0 h-1 bg-gradient-to-r from-blue-500 via-indigo-500 to-violet-500 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>

                    <div class="p-4 flex flex-col flex-1">
                        <!-- Header -->
                        <div class="flex items-start justify-between mb-3">
                            <div class="min-w-0 pr-2">
                                <h3 class="text-sm font-bold text-slate-900 group-hover:text-blue-600 transition-colors truncate" title="{{ $group->name }}">
                                    {{ $group->name }}
                                </h3>
                                <div class="flex items-center gap-1 mt-1">
                                    <span class="px-1.5 py-0.5 rounded text-[9px] font-bold uppercase tracking-wider bg-slate-100 text-slate-500 group-hover:bg-blue-50 group-hover:text-blue-600 transition-colors">
                                        {{ $group->code }}
                                    </span>
                                </div>
                            </div>
                            <div class="w-8 h-8 flex-shrink-0 rounded-lg bg-slate-50 text-slate-400 flex items-center justify-center group-hover:bg-blue-50 group-hover:text-blue-600 transition-all duration-300 shadow-sm">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                </svg>
                            </div>
                        </div>

                        <!-- Stats / Modules -->
                        <div class="mt-auto space-y-2">
                            @if(!empty($group->module_stats))
                                <div class="grid grid-cols-2 gap-1.5">
                                    @foreach($group->module_stats as $stat)
                                        <div class="flex flex-col p-1.5 rounded-md bg-slate-50 border border-slate-100 group-hover:border-blue-100/50 transition-colors">
                                            <span class="text-[9px] font-medium text-slate-500 uppercase tracking-tight truncate" title="{{ $stat['name'] }}">
                                                {{ $stat['name'] }}
                                            </span>
                                            <div class="flex items-center justify-between mt-0.5">
                                                @if($stat['pending'] > 0)
                                                    <span class="text-[10px] font-bold text-red-600 flex items-center gap-1">
                                                        {{ $stat['pending'] }}
                                                        <span class="w-1 h-1 rounded-full bg-red-500 animate-pulse"></span>
                                                    </span>
                                                @else
                                                    <span class="text-[10px] font-bold text-emerald-600 flex items-center gap-1">
                                                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                                        </svg>
                                                        Done
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <div class="flex flex-col items-center justify-center py-4 text-center border border-dashed border-slate-100 rounded-lg bg-slate-50/50">
                                    <span class="text-[10px] font-medium text-slate-400">No active modules</span>
                                </div>
                            @endif
                        </div>
                    </div>
                </a>
            @empty
                <div class="col-span-full flex flex-col items-center justify-center py-16 px-4 bg-white rounded-2xl border border-dashed border-slate-200 text-center">
                    <div class="w-12 h-12 bg-blue-50 text-blue-500 rounded-xl flex items-center justify-center mb-3 shadow-sm ring-4 ring-blue-50/50">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                        </svg>
                    </div>
                    <h3 class="text-sm font-bold text-slate-900 mb-0.5">No Groups</h3>
                    <p class="text-xs text-slate-500 mb-4">Create your first compliance group.</p>
                    <a href="{{ route('admin.compliance-groups.create') }}"
                        class="inline-flex items-center gap-1.5 px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-xs font-semibold rounded-md shadow hover:shadow-md transition-all duration-200">
                        <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                        </svg>
                        Create Group
                    </a>
                </div>
            @endforelse

        </div>
    </div>
@endsection